<?php
// views/user.php
// View ini digunakan untuk menampilkan daftar semua pengguna.
// Variabel yang diharapkan: $users (array asosiatif berisi data pengguna)
// Variabel ini disediakan oleh UserController->listUsers() (jika ada) atau UserController->index()

// Pesan sukses atau error dari sesi
if (isset($_SESSION['error_message'])) {
    echo "<p class='message error'>" . htmlspecialchars($_SESSION['error_message']) . "</p>";
    unset($_SESSION['error_message']);
}
if (isset($_SESSION['success_message'])) {
    echo "<p class='message success'>" . htmlspecialchars($_SESSION['success_message']) . "</p>";
    unset($_SESSION['success_message']);
}
?>

<div class="main-content-container">
    <h1 class="page-title">Daftar Pengguna</h1>
    <p class="page-description">Kelola data pengguna yang terdaftar dalam sistem.</p>

    <div class="action-bar">
        <a href="index.php?hal=user_create" class="add-button">
            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-plus-circle"><circle cx="12" cy="12" r="10"></circle><line x1="12" y1="8" x2="12" y2="16"></line><line x1="8" y1="12" x2="16" y2="12"></line></svg>
            Tambah Pengguna Baru
        </a>
    </div>

    <?php if (!empty($users)): ?>
        <div class="table-container">
            <table class="styled-table">
                <thead>
                    <tr>
                        <th>No.</th>
                        <th>Username</th>
                        <th>Nama Lengkap</th>
                        <th>Email</th>
                        <th>Peran</th>
                        <th class="text-center">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $no = 1; ?>
                    <?php foreach ($users as $user): ?>
                        <tr>
                            <td><?php echo $no++; ?></td>
                            <td><?php echo htmlspecialchars($user['username']); ?></td>
                            <td><?php echo htmlspecialchars($user['fullname']); ?></td>
                            <td><?php echo htmlspecialchars(ucfirst($user['role'])); ?></td>
                            <td><?php echo htmlspecialchars($user['email']); ?></td>
                            <td class="action-buttons-cell">
                                <a href="index.php?hal=user_detail&id=<?php echo htmlspecialchars($user['id']); ?>"
                                   class="action-btn action-btn-primary">
                                    Detail
                                </a>
                                <a href="index.php?hal=user_edit&id=<?php echo htmlspecialchars($user['id']); ?>"
                                   class="action-btn action-btn-edit">
                                    Edit
                                </a>
                                <button type="button" class="action-btn action-btn-danger open-delete-modal"
                                        data-id="<?php echo htmlspecialchars($user['id']); ?>"
                                        data-name="<?php echo htmlspecialchars($user['fullname']); ?>">
                                    Hapus
                                </button>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    <?php else: ?>
        <div class="empty-state">
            <svg xmlns="http://www.w3.org/2000/svg" width="60" height="60" viewBox="0 0 24 24" fill="none" stroke="#ccc" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-users"><path d="M17 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"></path><circle cx="9" cy="7" r="4"></circle><path d="M23 21v-2a4 4 0 0 0-3-3.87"></path><path d="M16 3.13a4 4 0 0 1 0 7.75"></path></svg>
            <p>Belum ada pengguna yang terdaftar.</p>
            <a href="index.php?hal=user_create" class="action-button">Tambah Pengguna Pertama Anda!</a>
        </div>
    <?php endif; ?>
</div>

<div id="deleteConfirmationModal" class="modal">
    <div class="modal-content">
        <span class="close-button">&times;</span>
        <div class="modal-header">
            <i class="bi bi-exclamation-triangle-fill modal-icon"></i>
            <h2>Konfirmasi Hapus Pengguna</h2>
        </div>
        <div class="modal-body">
            <p>Anda yakin ingin menghapus pengguna <strong id="userNameToDelete"></strong>?</p>
            <p>Tindakan ini tidak dapat dibatalkan dan semua data terkait pengguna ini (termasuk pemesanan) akan dihapus.</p>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn-cancel">Batal</button>
            <button type="button" class="btn-confirm-delete">Hapus</button>
        </div>
    </div>
</div>

<form id="deleteUserForm" method="POST" action="">
    <input type="hidden" name="id" id="deleteUserId">
</form>

<div id="loadingOverlay" class="loading-overlay">
    <div class="spinner"></div>
    <p>Menghapus pengguna, mohon tunggu...</p>
</div>

---

<style>
    /* Global/Base Styles (dari halaman film) */
    body {
        font-family: 'Poppins', sans-serif;
        background-color: #f0f2f5;
        color: #333;
        line-height: 1.6;
        margin: 0;
        padding: 0;
    }

    /* Message Styling (Success/Error) - dari halaman film */
    .message {
        padding: 12px 20px;
        margin: 20px auto;
        border-radius: 8px;
        text-align: center;
        font-weight: 600;
        max-width: 900px;
        box-sizing: border-box;
        animation: fadeInDown 0.5s ease-out;
        box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    }
    @keyframes fadeInDown {
        from { opacity: 0; transform: translateY(-20px); }
        to { opacity: 1; transform: translateY(0); }
    }
    .message.error {
        background-color: #f8d7da; color: #721c24; border: 1px solid #f5c6cb;
    }
    .message.success {
        background-color: #d4edda; color: #155724; border: 1px solid #c3e6cb;
    }

    /* Main Container for the Page (mirip film-list-container) */
    .main-content-container {
        max-width: 1200px;
        margin: 30px auto;
        padding: 30px;
        background-color: #ffffff;
        border-radius: 12px;
        box-shadow: 0 6px 20px rgba(0, 0, 0, 0.1);
        animation: fadeIn 0.8s ease-out;
    }
    @keyframes fadeIn {
        from { opacity: 0; transform: translateY(20px); }
        to { opacity: 1; transform: translateY(0); }
    }

    .page-title {
        text-align: center;
        color: #1a2a3a;
        font-size: 2.8em;
        font-weight: 800;
        margin-bottom: 10px;
        position: relative;
        padding-bottom: 15px;
    }
    .page-title::after {
        content: '';
        width: 80px;
        height: 4px;
        background-color: #007bff;
        position: absolute;
        bottom: 0;
        left: 50%;
        transform: translateX(-50%);
        border-radius: 2px;
    }

    .page-description {
        text-align: center;
        color: #6a737d;
        font-size: 1.1em;
        margin-bottom: 30px;
        line-height: 1.5;
    }

    /* Action Bar (Tambah Pengguna Baru) - mirip add-film-button */
    .action-bar {
        text-align: right;
        margin-bottom: 25px;
        padding-bottom: 15px;
        border-bottom: 1px solid #eee;
    }
    .add-button { /* Disesuaikan dari add-film-button */
        background-color: #4CAF50;
        color: white;
        padding: 10px 20px;
        border-radius: 30px;
        text-decoration: none;
        font-weight: 600;
        font-size: 0.95em;
        display: inline-flex;
        align-items: center;
        gap: 8px;
        transition: background-color 0.2s ease, transform 0.2s ease;
        box-shadow: 0 3px 8px rgba(76,175,80,0.2);
    }
    .add-button:hover {
        background-color: #45a049;
        color: white;
        transform: translateY(-2px);
    }
    .add-button svg {
        vertical-align: middle;
    }

    /* Table Styling */
    .table-container {
        overflow-x: auto;
        margin-top: 20px;
        background-color: #fff;
        border-radius: 12px;
        box-shadow: 0 5px 15px rgba(0,0,0,0.08);
        padding: 20px;
    }

    .styled-table {
        width: 100%;
        border-collapse: collapse;
        margin: 0;
        font-size: 0.95em;
    }

    .styled-table th,
    .styled-table td {
        padding: 12px 15px;
        border: 1px solid #e0e0e0;
        text-align: left;
    }

    .styled-table thead tr {
        background-color: #007bff;
        color: white;
        text-align: left;
        font-weight: 600;
    }

    .styled-table tbody tr:nth-of-type(even) {
        background-color: #f6f6f6;
    }

    .styled-table tbody tr:hover {
        background-color: #e9f5ff;
        cursor: pointer;
    }

    .styled-table td.text-center {
        text-align: center;
    }

    .action-buttons-cell {
        display: flex;
        flex-wrap: wrap;
        gap: 8px;
        justify-content: center;
        align-items: center;
    }

    /* Tombol Aksi - Warna Minimalis (dari halaman film) */
    .action-btn {
        padding: 8px 12px;
        border-radius: 20px;
        text-decoration: none;
        font-weight: 600;
        font-size: 0.85em;
        transition: all 0.2s ease;
        text-align: center;
        white-space: nowrap;
        box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        border: 1px solid transparent;
        display: inline-block;
        cursor: pointer; /* Pastikan cursor tetap pointer untuk button */
    }
    .action-btn-primary {
        background-color: #007bff;
        color: white;
    }
    .action-btn-primary:hover {
        background-color: #0056b3;
        color: white;
        transform: translateY(-1px);
    }
    .action-btn-edit {
        background-color: #17a2b8;
        color: white;
        border-color: #17a2b8;
    }
    .action-btn-edit:hover {
        background-color: #138496;
        border-color: #138496;
        color: white; /* Di sini tetap putih agar kontras dengan biru tua */
        transform: translateY(-1px);
    }
    .action-btn-danger {
        background-color: #dc3545;
        color: white;
        border: none;
        cursor: pointer;
    }
    .action-btn-danger:hover {
        background-color: #c82333;
        transform: translateY(-1px);
    }

    /* DELETE MODAL STYLES (from previous version, ensuring display:none by default) */
    .modal {
        display: none; /* Hidden by default */
        position: fixed; /* Stay in place */
        z-index: 1000; /* Sit on top */
        left: 0;
        top: 0;
        width: 100%; /* Full width */
        height: 100%; /* Full height */
        overflow: auto; /* Enable scroll if needed */
        background-color: rgba(0,0,0,0.6); /* Black w/ opacity */
        justify-content: center;
        align-items: center;
        animation: fadeInOverlay 0.3s forwards;
    }

    .modal.show { /* Add this new class to trigger display */
        display: flex;
    }

    @keyframes fadeInOverlay {
        from { opacity: 0; }
        to { opacity: 1; }
    }

    .modal-content {
        background-color: #fefefe;
        padding: 30px;
        border-radius: 12px;
        box-shadow: 0 8px 25px rgba(0,0,0,0.2);
        width: 90%;
        max-width: 500px;
        position: relative;
        animation: popInModal 0.3s forwards;
        transform: scale(0.95); /* Initial scale for pop-in effect */
        opacity: 0;
        display: flex;
        flex-direction: column;
        gap: 20px;
    }

    @keyframes popInModal {
        from { opacity: 0; transform: scale(0.95); }
        to { opacity: 1; transform: scale(1); }
    }

    .close-button {
        color: #aaa;
        position: absolute;
        top: 15px;
        right: 20px;
        font-size: 32px;
        font-weight: bold;
        cursor: pointer;
        transition: color 0.2s ease;
    }

    .close-button:hover,
    .close-button:focus {
        color: #333;
    }

    .modal-header {
        display: flex;
        align-items: center;
        gap: 15px;
        border-bottom: 1px solid #eee;
        padding-bottom: 15px;
        margin-bottom: 20px;
    }

    .modal-icon {
        color: #ffc107; /* Warning yellow */
        font-size: 2.5em;
        flex-shrink: 0; /* Jangan menyusut */
    }

    .modal-header h2 {
        margin: 0;
        color: #333;
        font-size: 1.8em;
        font-weight: 700;
        line-height: 1.2;
    }

    .modal-body {
        font-size: 1.05em;
        line-height: 1.6;
        color: #555;
    }

    .modal-body strong {
        color: #1a2a3a;
    }

    .modal-footer {
        display: flex;
        justify-content: flex-end;
        gap: 10px;
        padding-top: 20px;
        border-top: 1px solid #eee;
        margin-top: 20px;
    }

    .btn-cancel,
    .btn-confirm-delete {
        padding: 12px 25px;
        border-radius: 8px;
        font-size: 1em;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.2s ease;
        border: none; /* Default for buttons */
    }

    .btn-cancel {
        background-color: #6c757d; /* Secondary grey */
        color: white;
    }
    .btn-cancel:hover {
        background-color: #5a6268;
        transform: translateY(-1px);
    }

    .btn-confirm-delete {
        background-color: #dc3545; /* Danger red */
        color: white;
    }
    .btn-confirm-delete:hover {
        background-color: #c82333;
        transform: translateY(-1px);
    }

    /* NEW: Loading Overlay Styles */
    .loading-overlay {
        display: none; /* Hidden by default */
        position: fixed; /* Cover the whole screen */
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background-color: rgba(255, 255, 255, 0.8); /* Semi-transparent white */
        z-index: 1001; /* Above modal */
        flex-direction: column;
        justify-content: center;
        align-items: center;
        backdrop-filter: blur(5px); /* Efek blur pada latar belakang */
        animation: fadeInLoading 0.3s forwards;
    }

    @keyframes fadeInLoading {
        from { opacity: 0; }
        to { opacity: 1; }
    }

    .spinner {
        border: 8px solid #f3f3f3; /* Light grey */
        border-top: 8px solid #007bff; /* Blue */
        border-radius: 50%;
        width: 60px;
        height: 60px;
        animation: spin 1s linear infinite;
        margin-bottom: 20px;
    }

    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }

    .loading-overlay p {
        color: #333;
        font-size: 1.2em;
        font-weight: 600;
        margin: 0;
    }


    /* Responsive Adjustments */
    @media (max-width: 992px) {
        .main-content-container {
            max-width: 90%;
        }
        .styled-table th,
        .styled-table td {
            padding: 10px 12px;
            font-size: 0.9em;
        }
        .action-buttons-cell {
            flex-direction: column;
            align-items: stretch;
        }
        .action-btn {
            width: 100%;
            min-width: unset;
            margin-bottom: 5px;
        }
        .modal-content {
            padding: 20px;
        }
        .modal-header h2 {
            font-size: 1.5em;
        }
        .modal-icon {
            font-size: 2em;
        }
        .modal-body {
            font-size: 0.95em;
        }
        .btn-cancel,
        .btn-confirm-delete {
            padding: 10px 20px;
            font-size: 0.9em;
        }
        .spinner {
            width: 50px;
            height: 50px;
        }
        .loading-overlay p {
            font-size: 1.1em;
        }
    }
    @media (max-width: 768px) {
        .main-content-container {
            margin: 20px 15px;
            padding: 20px;
        }
        .page-title {
            font-size: 2.2em;
        }
        .page-description {
            font-size: 1em;
        }
        .action-bar {
            text-align: center;
        }
        .add-button {
            width: 100%;
            box-sizing: border-box;
            justify-content: center;
        }
        .styled-table, .table-container {
            border-radius: 8px;
        }
        .styled-table thead {
            display: none;
        }
        .styled-table, .styled-table tbody, .styled-table tr, .styled-table td {
            display: block;
            width: 100%;
        }
        .styled-table tr {
            margin-bottom: 15px;
            border: 1px solid #e0e0e0;
            border-radius: 8px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.05);
            padding: 10px;
            background-color: #fff;
        }
        .styled-table td {
            text-align: right !important;
            padding-left: 50% !important;
            position: relative;
            border: none;
        }
        .styled-table td::before {
            content: attr(data-label);
            position: absolute;
            left: 10px;
            width: calc(50% - 20px);
            padding-right: 10px;
            white-space: nowrap;
            text-align: left;
            font-weight: 600;
            color: #555;
        }
        .styled-table td:first-child::before { content: "No."; }
        .styled-table td:nth-child(2)::before { content: "Username:"; }
        .styled-table td:nth-child(3)::before { content: "Nama Lengkap:"; }
        .styled-table td:nth-child(4)::before { content: "Email:"; }
        .styled-table td:nth-child(5)::before { content: "Peran:"; }
        .styled-table td:last-child::before { content: "Aksi:"; }

        .action-buttons-cell {
            justify-content: flex-end;
            padding-left: 0 !important;
        }
    }
    @media (max-width: 480px) {
        .page-title {
            font-size: 2em;
        }
        .action-btn {
            font-size: 0.8em;
            padding: 7px 10px;
        }
        .modal-header h2 {
            font-size: 1.3em;
        }
        .modal-icon {
            font-size: 1.8em;
        }
        .modal-body {
            font-size: 0.9em;
        }
        .btn-cancel,
        .btn-confirm-delete {
            padding: 8px 15px;
            font-size: 0.8em;
        }
        .spinner {
            width: 40px;
            height: 40px;
        }
        .loading-overlay p {
            font-size: 1em;
        }
    }
</style>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const deleteModal = document.getElementById('deleteConfirmationModal');
        const closeButton = document.querySelector('.modal .close-button');
        const cancelButton = document.querySelector('.modal .btn-cancel');
        const confirmDeleteButton = document.querySelector('.modal .btn-confirm-delete');
        const deleteUserButtons = document.querySelectorAll('.open-delete-modal');
        const deleteUserForm = document.getElementById('deleteUserForm');
        const deleteUserIdInput = document.getElementById('deleteUserId');
        const userNameToDeleteSpan = document.getElementById('userNameToDelete');
        const loadingOverlay = document.getElementById('loadingOverlay'); // NEW: Get loading overlay

        let userIdToDelete = null;

        // Function to open the modal
        deleteUserButtons.forEach(button => {
            button.addEventListener('click', function() {
                userIdToDelete = this.dataset.id;
                const userName = this.dataset.name;
                userNameToDeleteSpan.textContent = userName;
                deleteModal.classList.add('show');
            });
        });

        // Function to close the modal
        function closeModal() {
            deleteModal.classList.remove('show');
            userIdToDelete = null;
            userNameToDeleteSpan.textContent = '';
        }

        // Event listeners for closing the modal
        closeButton.addEventListener('click', closeModal);
        cancelButton.addEventListener('click', closeModal);

        // Close modal if user clicks outside of it
        window.addEventListener('click', function(event) {
            if (event.target == deleteModal) {
                closeModal();
            }
        });

        // Handle confirm delete button click
        confirmDeleteButton.addEventListener('click', function() {
            if (userIdToDelete) {
                // Show loading overlay BEFORE submitting the form
                loadingOverlay.style.display = 'flex'; // Show the loading overlay
                
                deleteUserIdInput.value = userIdToDelete;
                deleteUserForm.action = `index.php?hal=user_destroy&id=${userIdToDelete}`;
                deleteUserForm.submit(); // Submit the hidden form
            }
            // closeModal() is called implicitly as the page will redirect on form submission
            // No need to hide modal here, as the page will reload
        });

        // Optional: Hide loading overlay if page load fails or if there's a back navigation
        // This is less critical because a successful delete will reload the page,
        // but can be useful for edge cases.
        window.addEventListener('pageshow', function(event) {
            if (event.persisted) { // If page is restored from cache (e.g., back button)
                loadingOverlay.style.display = 'none';
            }
        });
    });
</script>