<?php
    //ciptakan object dari class Studio
    $obj_studio = new Studio();

    //panggil fungsi untuk menampilkan data studio yang akan diupdate
    $idedit = htmlspecialchars($_REQUEST['idedit'] ?? '');
    $studio = !empty($idedit) ? $obj_studio->getStudio($idedit) : array() ;
    
    $sesi = $_SESSION['USERS'] ?? null;
    if(isset($sesi) && ($sesi['role'] == 'admin' || $sesi['role'] == 'staff') ){ // Hanya admin dan staff yang bisa akses
?>

<section class="page-title bg-title overlay-dark">
    <div class="container">
        <div class="row">
            <div class="col-12 text-center">
                <div class="title mt-5">
                    <h3>Update Data Studio</h3>
                </div>
                <ol class="breadcrumb justify-content-center p-0 m-0">
                    <li class="breadcrumb-item"><a href="index.php?hal=home">Home</a></li>
                    <li class="breadcrumb-item active">Data Bioskop</li>
                    <li class="breadcrumb-item active">Data Studio</li>
                    <li class="breadcrumb-item active">Update Data Studio</li>
                </ol>
            </div>
        </div>
    </div>
</section>

<section class="section contact-form">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="section-title">
                    <h3>Update <span class="alternate">Data Studio</span></h3>
                </div>
            </div>
        </div>
        <form action="controllers/StudioController.php" method="POST" class="row">
            <div class="col-md-6 mt-5">
                <label class="form-label fw-bold" for="nama">Nama Studio</label>
                <input type="text" class="form-control main" name="nama" id="nama" placeholder="Nama Studio"
                value="<?= htmlspecialchars($studio['nama'] ?? '') ?>" required>
            </div>
            <div class="col-md-6 mt-5">
                <label class="form-label fw-bold" for="foto">Foto (Nama File Gambar)</label>
                <input type="text" class="form-control main" name="foto" id="foto" placeholder="Contoh: studio_a.jpg"
                value="<?= htmlspecialchars($studio['foto'] ?? '') ?>" required>
                <small class="form-text text-muted">Masukkan nama file gambar (misal: 'studio_a.jpg') yang ada di folder assets/img/studio.</small>
            </div>

            <div class="col-12 text-center mt-4">
                <button type="submit" name="proses" value="ubah" class="btn btn-success btn-md m-3">Ubah</button>
                <input type="hidden" name="idx" value="<?= htmlspecialchars($idedit) ?>">
                <button type="submit" name="proses" value="batal" class="btn btn-danger btn-md">Batal</button>
            </div>
        </form>
    </div>
</section>
<?php 
}
else{
    // Jika tidak punya hak akses, arahkan kembali ke halaman login_form.php dengan pesan error
    echo '<script>alert("Anda Dilarang Akses Halaman Ini !!!");history.back();</script>';
}
?>