<?php
// views/pemesanan_summary.php
// View ini digunakan untuk menampilkan ringkasan pemesanan yang baru dibuat.
// Variabel yang diharapkan: $ordered_seats_details (array detail kursi yang baru dipesan)
// Variabel ini disediakan oleh PemesananController->showSummary()

// Pesan sukses atau error dari sesi
if (isset($_SESSION['error_message'])) {
    echo "<p style='color: red; text-align: center; font-weight: bold;'>" . htmlspecialchars($_SESSION['error_message']) . "</p>";
    unset($_SESSION['error_message']);
}
if (isset($_SESSION['success_message'])) {
    echo "<p style='color: green; text-align: center; font-weight: bold;'>" . htmlspecialchars($_SESSION['success_message']) . "</p>";
    unset($_SESSION['success_message']);
}

// Pastikan $ordered_seats_details tidak kosong
if (!isset($ordered_seats_details) || empty($ordered_seats_details)) {
    echo "<p style='color: red; text-align: center;'>Tidak ada detail pemesanan untuk ditampilkan. Silakan coba memesan ulang.</p>";
    return;
}

// Ambil data dari elemen pertama (karena semua harus dari jadwal yang sama)
$first_order = $ordered_seats_details[0];
$film_judul = $first_order['film_judul'];
$studio_nama = $first_order['studio_nama'];
$tanggal_tayang = $first_order['tanggal_tayang'];
$waktu_tayang = substr($first_order['waktu_tayang'], 0, 5);
$harga_per_kursi = $first_order['harga_saat_pemesanan'];
$total_harga_semua_kursi = count($ordered_seats_details) * $harga_per_kursi;
$kursi_dipilih_nomor = [];
$ordered_detail_ids_string = []; // Untuk ID detail pemesanan yang berhasil
foreach ($ordered_seats_details as $detail) {
    $kursi_dipilih_nomor[] = $detail['kursi_nomor'];
    $ordered_detail_ids_string[] = $detail['id'];
}
$kursi_string = implode(', ', $kursi_dipilih_nomor);
$ordered_detail_ids_string_for_url = implode(',', $ordered_detail_ids_string); // Digunakan untuk update status jika perlu
?>

<div style="max-width: 800px; margin: 20px auto; padding: 25px; border: 1px solid #ddd; border-radius: 10px; box-shadow: 0 4px 12px rgba(0,0,0,0.1);">
    <h1 style="text-align: center; color: #333; margin-bottom: 25px;">Ringkasan Pemesanan Anda</h1>
    
    <div style="margin-bottom: 30px; padding: 15px; border: 1px solid #eee; border-radius: 8px; background-color: #f9f9f9;">
        <h3 style="color: #007bff; margin-bottom: 15px;">Detail Film & Jadwal</h3>
        <p><strong>Film:</strong> <?= htmlspecialchars($film_judul) ?></p>
        <p><strong>Studio:</strong> <?= htmlspecialchars($studio_nama) ?></p>
        <p><strong>Tanggal Tayang:</strong> <?= htmlspecialchars($tanggal_tayang) ?></p>
        <p><strong>Waktu Tayang:</strong> <?= htmlspecialchars($waktu_tayang) ?></p>
    </div>

    <div style="margin-bottom: 30px; padding: 15px; border: 1px solid #eee; border-radius: 8px; background-color: #f9f9f9;">
        <h3 style="color: #007bff; margin-bottom: 15px;">Kursi yang Dipilih</h3>
        <p><strong>Nomor Kursi:</strong> <?= htmlspecialchars($kursi_string) ?></p>
        <p><strong>Jumlah Kursi:</strong> <?= count($ordered_seats_details) ?></p>
        <p><strong>Harga per Kursi:</strong> Rp <?= number_format($harga_per_kursi, 0, ',', '.') ?></p>
    </div>

    <div style="text-align: center; background-color: #e6ffe6; padding: 20px; border-radius: 8px; border: 1px solid #a3e6a3; margin-bottom: 30px;">
        <h3 style="color: #28a745; margin-bottom: 15px;">Total Harga</h3>
        <p style="font-size: 2.2em; font-weight: bold; color: #28a745;">
            Rp <?= number_format($total_harga_semua_kursi, 0, ',', '.') ?>
        </p>
    </div>

    <h3 style="text-align: center; color: #333; margin-bottom: 20px;">Pilih Metode Pembayaran</h3>
    <div style="display: flex; flex-direction: column; gap: 15px; margin-bottom: 30px; padding: 15px; border: 1px solid #ddd; border-radius: 8px; background-color: #f9f9f9;">
        <label style="display: flex; align-items: center; gap: 10px; font-size: 1.1em; cursor: pointer;">
            <input type="radio" name="payment_method" value="qris" required> QRIS
        </label>
        <label style="display: flex; align-items: center; gap: 10px; font-size: 1.1em; cursor: pointer;">
            <input type="radio" name="payment_method" value="credit_card"> Kartu Kredit
        </label>
        <label style="display: flex; align-items: center; gap: 10px; font-size: 1.1em; cursor: pointer;">
            <input type="radio" name="payment_method" value="ewallet"> E-Wallet (Dana, OVO, GoPay)
        </label>
    </div>

    <div style="text-align: center; margin-top: 20px;">
        <p style="color: #555; margin-bottom: 15px;">Status pemesanan Anda saat ini adalah **Pending**. Silakan pilih metode pembayaran dan lanjutkan.</p>
        
        <!-- Tombol ini akan mengarahkan ke halaman riwayat pemesanan dan menandai sebagai lunas (simulasi) -->
        <a href="index.php?hal=pemesanan_update_status&id=<?= htmlspecialchars($ordered_detail_ids_string_for_url) ?>&status=paid" 
           style="background-color: #007bff; color: white; padding: 15px 30px; border-radius: 8px; text-decoration: none; font-size: 1.2em; display: inline-block; transition: background-color 0.3s ease;">
           Lanjutkan Pembayaran (Simulasi Lunas)
        </a>
    </div>
</div>
