<?php
// views/navigation.php
// Pastikan session_start() sudah dipanggil di index.php
// Data yang digunakan dari sesi: $_SESSION['user_id'], $_SESSION['username'], $_SESSION['user_role'], $_SESSION['fullname'], $_SESSION['foto']

// --- PENTING: PASTIKAN TIDAK ADA KARAKTER APAPUN (SPASI, BARIS BARU, DLL.) SEBELUM TAG <?php INI ---

// Ambil data sesi yang relevan
$is_logged_in = isset($_SESSION['user_id']);
$user_fullname = $_SESSION['fullname'] ?? $_SESSION['username'] ?? ''; // Fallback ke username jika fullname tidak ada di sesi
$user_role = $_SESSION['user_role'] ?? 'user'; // Default 'user' jika tidak ada peran di sesi
$user_id_from_session = $_SESSION['user_id'] ?? null;
$user_photo = $_SESSION['foto'] ?? 'default.jpg'; // Path foto, default ke default.jpg

?>

<style>
    /* Custom styles for the unique logout modal */
    .unique-modal-backdrop.modal-backdrop.show {
        opacity: 0.75; /* Slightly more opaque backdrop */
        background-color: #3f51b5; /* A more distinct, perhaps indigo-like color */
    }

    .unique-modal-dialog {
        transform: scale(0.9); /* Start slightly smaller for animation */
        transition: transform 0.3s ease-out, opacity 0.3s ease-out;
    }

    .unique-modal-dialog.show {
        transform: scale(1); /* Scale up to normal size when shown */
    }

    .unique-modal-content {
        border-radius: 15px; /* More rounded corners */
        background-color: #f7f7f7; /* Light grey background */
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2); /* Stronger, softer shadow */
        border: none; /* Remove default border */
        overflow: hidden; /* Ensure content respects border-radius */
    }

    .unique-modal-header {
        background-color: #5f75e0; /* A vibrant header color */
        color: white; /* White text for header */
        border-bottom: none; /* No header border */
        padding: 20px 25px;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .unique-modal-header .btn-close {
        filter: invert(1) grayscale(100%) brightness(200%); /* Make close button white */
        opacity: 0.8;
        font-size: 1.2rem;
    }

    .unique-modal-header .btn-close:hover {
        opacity: 1;
    }

    .unique-modal-title {
        font-weight: 600;
        font-size: 1.35rem;
    }

    .unique-modal-body {
        padding: 30px 25px;
        font-size: 1.1rem;
        color: #333;
        text-align: center;
    }

    .unique-modal-footer {
        border-top: none; /* No footer border */
        padding: 20px 25px;
        background-color: #f0f0f0; /* Slightly different background for footer */
        display: flex;
        justify-content: center; /* Center buttons */
        gap: 15px; /* Space between buttons */
    }

    .unique-modal-footer .btn {
        min-width: 100px; /* Ensure buttons have a minimum width */
        padding: 10px 20px;
        border-radius: 8px; /* Slightly rounded buttons */
        font-weight: 500;
        transition: all 0.2s ease;
    }

    .unique-modal-footer .btn-secondary-custom {
        background-color: #cccccc; /* Custom light grey for cancel */
        border-color: #cccccc;
        color: #444444;
    }

    .unique-modal-footer .btn-secondary-custom:hover {
        background-color: #bbbbbb;
        border-color: #bbbbbb;
    }

    .unique-modal-footer .btn-primary-custom {
        background-color: #5f75e0; /* Custom vibrant color for logout */
        border-color: #5f75e0;
        color: white;
    }

    .unique-modal-footer .btn-primary-custom:hover {
        background-color: #4a5dc7;
        border-color: #4a5dc7;
    }

    /* Additional style for user photo in header for better alignment */
    .navbar .user-profile-img {
        border-radius: 50%;
        margin-left: 10px;
        width: 45px; /* Slightly smaller to fit better */
        height: 45px;
        margin-top: 10px; /* Adjust top margin for vertical alignment */
        object-fit: cover;
        border: 2px solid rgba(255, 255, 255, 0.8); /* Small border for emphasis */
    }

    /* Small adjustment for dropdowns to align correctly if needed */
    #navbar ul .dropdown ul {
        margin-top: 5px;
        border-radius: 8px;
        box-shadow: 0px 0px 30px rgba(127, 137, 161, 0.25);
    }

</style>

<header id="header" class="d-flex fixed-top align-items-center" style="padding: 15px 15px 30px 15px;">
    <div class="container d-flex justify-content-between align-items-center">

        <div class="logo">
            <h1><a href="index.php?hal=home">Cinema SI</a></h1> </div>

        <nav id="navbar" class="navbar">
            <ul>
                <li><a href="index.php?hal=home" class="link">Home</a></li> <li><a href="index.php?hal=about" class="link">About</a></li> <li><a href="index.php?hal=blog" class="link">Blog</a></li> <li><a href="index.php?hal=kontak" class="link">Contact</a></li> <?php if (!$is_logged_in): ?>
                    <li class="nav-item">
                        <a class="nav-link" href="index.php?hal=login">Login</a>
                    </li>
                <?php else: // Jika sudah login ?>
                    <li class="dropdown"><a href="#"><span>Data Bioskop</span> <i class="bi bi-chevron-down"></i></a>
                        <ul>
                            <?php if ($user_role == 'admin'): // Hanya admin yang bisa melihat menu ini secara default ?>
                                <li><a href="index.php?hal=user">Data Users</a></li> <li><a href="index.php?hal=film">Data Film</a></li> <li><a href="index.php?hal=jadwal">Data Jadwal</a></li> <li><a href="index.php?hal=kursi">Data Kursi</a></li> <li><a href="index.php?hal=pemesanan_all">Data Pemesanan (Admin)</a></li> <?php endif; ?>
                            <?php if ($user_role == 'user'): // Menu untuk user biasa ?>
                                <li><a href="index.php?hal=pemesanan_list">Riwayat Pemesanan Saya</a></li> <?php endif; ?>
                        </ul>
                    </li>
                    <li class="nav-item dropdown">
                        <a class="nav-link" href="#" data-toggle="dropdown"><?= htmlspecialchars($user_fullname) ?> 
                            <i class="bi bi-chevron-down"></i>
                        </a>
                        <ul class="dropdown-menu">
                            <li><a href="index.php?hal=user_detail&id=<?= htmlspecialchars($user_id_from_session) ?>">Profile</a></li>
                            <?php if ($user_role == 'admin'): ?>
                                <li><a class="dropdown-item" href="index.php?hal=user">Kelola User</a></li>
                            <?php endif; ?>
                            <li><a class="dropdown-item" href="#" data-bs-toggle="modal" data-bs-target="#logoutConfirmModal">Logout</a></li> </ul>
                    </li>
                    <li class="nav-item">
                        <img src="<?= htmlspecialchars($user_photo) ?>" 
                             class="user-profile-img" 
                             alt="User Photo">
                    </li>
                <?php endif; ?>
            </ul>
            <i class="bi bi-list mobile-nav-toggle"></i>
        </nav>

    </div>
</header>

<div class="modal fade" id="logoutConfirmModal" tabindex="-1" aria-labelledby="logoutConfirmModalLabel" aria-hidden="true" data-bs-backdrop="static">
    <div class="modal-dialog unique-modal-dialog modal-dialog-centered"> <div class="modal-content unique-modal-content"> <div class="modal-header unique-modal-header"> <h5 class="modal-title unique-modal-title" id="logoutConfirmModalLabel"><i class="bi bi-box-arrow-right"></i> Konfirmasi Keluar</h5> <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body unique-modal-body"> Apakah Anda yakin ingin mengakhiri sesi Anda saat ini?
            </div>
            <div class="modal-footer unique-modal-footer"> <button type="button" class="btn btn-secondary-custom" data-bs-dismiss="modal">Batal</button> <a href="index.php?hal=logout" class="btn btn-primary-custom">Logout</a> </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Pastikan tidak ada JS yang mencoba mengarahkan ke modal login/register di sini

    // Custom animation for modal backdrop when it shows
    const logoutModal = document.getElementById('logoutConfirmModal');
    if (logoutModal) {
        logoutModal.addEventListener('show.bs.modal', function () {
            // Add custom class to backdrop for unique styling
            const backdrop = document.querySelector('.modal-backdrop');
            if (backdrop) {
                backdrop.classList.add('unique-modal-backdrop');
            }
            // Add show class to dialog for custom animation
            const dialog = logoutModal.querySelector('.unique-modal-dialog');
            if (dialog) {
                setTimeout(() => { // Small delay to ensure class is applied after modal fade-in starts
                    dialog.classList.add('show');
                }, 10);
            }
        });

        logoutModal.addEventListener('hide.bs.modal', function () {
            // Remove custom class from dialog when hiding
            const dialog = logoutModal.querySelector('.unique-modal-dialog');
            if (dialog) {
                dialog.classList.remove('show');
            }
            // Remove custom class from backdrop when hiding
            const backdrop = document.querySelector('.modal-backdrop.unique-modal-backdrop');
            if (backdrop) {
                backdrop.classList.remove('unique-modal-backdrop');
            }
        });
    }
});
</script>