<?php
// views/kursi_form_update.php
// View ini digunakan untuk menampilkan formulir pembaruan kursi.
// Variabel yang diharapkan:
// - $kursi (array asosiatif data kursi yang akan diedit)
// - $studios (array studio)
// Variabel-variabel ini disediakan oleh KursiController->edit()

// Pesan sukses atau error dari sesi
if (isset($_SESSION['error_message'])) {
    echo "<p class='message error'>" . htmlspecialchars($_SESSION['error_message']) . "</p>";
    unset($_SESSION['error_message']);
}
if (isset($_SESSION['success_message'])) {
    echo "<p class='message success'>" . htmlspecialchars($_SESSION['success_message']) . "</p>";
    unset($_SESSION['success_message']);
}

// Pastikan $kursi tidak kosong sebelum mencoba mengakses datanya
if (!isset($kursi) || !is_array($kursi)) {
    // Menggunakan kelas CSS untuk pesan error agar konsisten
    echo "<div class='form-container'><p class='message error' style='margin-bottom:20px;'>Data kursi tidak ditemukan untuk diedit.</p>";
    echo "<div class='form-actions' style='justify-content:center;'><a href='index.php?hal=kursi' class='action-button secondary-button'>Kembali ke Daftar Kursi</a></div></div>";
    return; // Hentikan eksekusi jika data kursi tidak ada
}
?>

<div class="form-container">
    <h1 class="page-title">Edit Kursi: <?= htmlspecialchars($kursi['nomor'] ?? 'N/A') ?></h1>
    <p class="page-description">Perbarui detail untuk kursi ini di Studio: <?= htmlspecialchars($kursi['studio_nama'] ?? 'N/A') ?>.</p>
    
    <form action="index.php?hal=kursi_update" method="POST" class="data-form">
        <input type="hidden" name="id" value="<?= htmlspecialchars($kursi['id'] ?? '') ?>">

        <div class="form-group">
            <label for="studio_id">Pilih Studio:</label>
            <select id="studio_id" name="studio_id" required class="form-control">
                <option value="">-- Pilih Studio --</option>
                <?php
                if (!empty($studios)) {
                    foreach ($studios as $studio) {
                        // Tandai studio yang sedang digunakan oleh kursi ini sebagai 'selected'
                        $selected = ((isset($kursi['studio_id']) && $studio['id'] == $kursi['studio_id'])) ? 'selected' : '';
                        echo "<option value='" . htmlspecialchars($studio['id']) . "' " . $selected . ">" . htmlspecialchars($studio['nama']) . "</option>";
                    }
                }
                ?>
            </select>
        </div>

        <div class="form-group">
            <label for="nomor">Nomor Kursi:</label>
            <input type="text" id="nomor" name="nomor" required class="form-control"
                   value="<?= htmlspecialchars($kursi['nomor'] ?? '') ?>"
                   placeholder="Contoh: A1, B10">
            <small class="form-text-hint">Gunakan format seperti A1, B2, C3.</small>
        </div>

        <div class="form-actions">
            <button type="submit" class="action-button primary-button">
                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-save"><path d="M19 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h11l5 5v11a2 2 0 0 1-2 2z"></path><polyline points="17 21 17 13 7 13 7 21"></polyline><polyline points="7 3 7 8 15 8"></polyline></svg>
                Perbarui Kursi
            </button>
            <a href="index.php?hal=kursi" class="action-button secondary-button">
                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-x-circle"><circle cx="12" cy="12" r="10"></circle><line x1="15" y1="9" x2="9" y2="15"></line><line x1="9" y1="9" x2="15" y2="15"></line></svg>
                Batal
            </a>
        </div>
    </form>
</div>

<style>
    /* Global/Base Styles (re-confirm from previous versions) */
    body {
        font-family: 'Poppins', sans-serif;
        background-color: #f0f2f5;
        color: #333;
        line-height: 1.6;
        margin: 0;
        padding: 0;
    }

    /* Message Styling (Success/Error) */
    .message {
        padding: 12px 20px;
        margin: 20px auto;
        border-radius: 8px;
        text-align: center;
        font-weight: 600;
        max-width: 900px;
        box-sizing: border-box;
        animation: fadeInDown 0.5s ease-out;
        box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    }
    @keyframes fadeInDown {
        from { opacity: 0; transform: translateY(-20px); }
        to { opacity: 1; transform: translateY(0); }
    }
    .message.error {
        background-color: #f8d7da; color: #721c24; border: 1px solid #f5c6cb;
    }
    .message.success {
        background-color: #d4edda; color: #155724; border: 1px solid #c3e6cb;
    }

    /* Form Container Styling */
    .form-container {
        max-width: 600px; /* Lebar yang lebih proporsional untuk form */
        margin: 30px auto;
        padding: 35px; /* Padding lebih besar */
        background-color: #ffffff;
        border-radius: 12px;
        box-shadow: 0 6px 20px rgba(0, 0, 0, 0.1);
        animation: fadeIn 0.8s ease-out;
    }
    @keyframes fadeIn {
        from { opacity: 0; transform: translateY(20px); }
        to { opacity: 1; transform: translateY(0); }
    }

    .page-title { /* Re-use film list title style */
        text-align: center;
        color: #1a2a3a;
        font-size: 2.5em; /* Sedikit lebih kecil dari list title */
        font-weight: 800;
        margin-bottom: 10px;
        position: relative;
        padding-bottom: 15px;
    }
    .page-title::after { /* Re-use film list title underline */
        content: '';
        width: 70px; /* Sedikit lebih kecil dari list title */
        height: 4px;
        background-color: #007bff;
        position: absolute;
        bottom: 0;
        left: 50%;
        transform: translateX(-50%);
        border-radius: 2px;
    }

    .page-description { /* Re-use film list description style */
        text-align: center;
        color: #6a737d;
        font-size: 1.05em;
        margin-bottom: 30px;
        line-height: 1.5;
    }

    /* Form Specific Styles */
    .data-form {
        display: flex;
        flex-direction: column;
        gap: 20px; /* Jarak antar form group */
    }

    .form-group {
        margin-bottom: 0; /* Diatur oleh gap di data-form */
    }

    .form-group label {
        display: block;
        margin-bottom: 8px;
        font-weight: 600;
        color: #333;
        font-size: 1.05em;
    }

    .form-control {
        width: 100%;
        padding: 12px 15px;
        border: 1px solid #ced4da;
        border-radius: 8px; /* Sudut lebih membulat */
        font-size: 1em;
        color: #495057;
        box-sizing: border-box; /* Penting untuk padding dan border */
        transition: border-color 0.2s ease, box-shadow 0.2s ease;
    }

    .form-control:focus {
        border-color: #007bff;
        outline: none;
        box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.25);
    }

    .form-control::placeholder {
        color: #6c757d;
        opacity: 0.7;
    }

    .form-text-hint {
        font-size: 0.9em;
        color: #6a737d;
        margin-top: 5px;
        display: block;
    }

    .form-actions {
        display: flex;
        justify-content: flex-end; /* Tombol ke kanan */
        gap: 15px; /* Jarak antar tombol */
        margin-top: 25px;
    }

    /* Action Buttons (Re-use from film.php) */
    .action-button {
        padding: 12px 25px;
        border-radius: 30px; /* Tombol membulat */
        text-decoration: none;
        font-weight: 600;
        font-size: 1em;
        cursor: pointer;
        transition: all 0.3s ease;
        text-align: center;
        border: none; /* Default no border */
        box-shadow: 0 3px 8px rgba(0,0,0,0.1);
        display: inline-flex; /* Untuk ikon SVG */
        align-items: center;
        gap: 8px; /* Jarak antara teks dan ikon */
    }

    .action-button.primary-button {
        background-color: #28a745; /* Hijau untuk update/save */
        color: white;
    }
    .action-button.primary-button:hover {
        background-color: #218838;
        transform: translateY(-2px);
        box-shadow: 0 5px 12px rgba(40, 167, 69, 0.3);
    }

    .action-button.secondary-button {
        background-color: #6c757d; /* Abu-abu sekunder */
        color: white;
    }
    .action-button.secondary-button:hover {
        background-color: #5a6268;
        transform: translateY(-2px);
        box-shadow: 0 5px 12px rgba(108, 117, 125, 0.3);
    }
    
    /* Responsive Adjustments */
    @media (max-width: 768px) {
        .form-container {
            margin: 20px 15px;
            padding: 25px;
        }
        .page-title {
            font-size: 2em;
        }
        .page-description {
            font-size: 0.95em;
        }
        .form-actions {
            flex-direction: column; /* Stack buttons on small screens */
            gap: 10px;
        }
        .action-button {
            width: 100%; /* Full width buttons */
            box-sizing: border-box;
            justify-content: center; /* Pusatkan teks dan ikon di tombol full-width */
        }
    }
    @media (max-width: 480px) {
        .form-container {
            padding: 20px;
        }
        .page-title {
            font-size: 1.8em;
            padding-bottom: 10px;
        }
        .page-title::after {
            width: 50px;
        }
        .form-group label {
            font-size: 1em;
        }
        .form-control {
            padding: 10px 12px;
            font-size: 0.95em;
        }
        .form-text-hint {
            font-size: 0.85em;
        }
    }
</style>