<?php
// views/home.php
// View ini digunakan untuk menampilkan halaman utama (homepage) aplikasi.
// Variabel yang diharapkan:
// - $films (array asosiatif berisi data film untuk bagian featured)
// - $total_users (int)
// - $total_studios (int)
// - $total_kategoris (int)
// - $total_films (int)
// Variabel-variabel ini akan disediakan oleh FilmController->index()

// Pastikan sesi sudah dimulai di awal script Anda, biasanya di bagian paling atas file PHP
// session_start();

// --- PENANGANAN PESAN SUKSES/ERROR YANG LEBIH CANGGIH ---
$flashMessages = [];

if (isset($_SESSION['error_message'])) {
    $flashMessages[] = [
        'type' => 'error',
        'text' => htmlspecialchars($_SESSION['error_message'])
    ];
    unset($_SESSION['error_message']);
}
if (isset($_SESSION['success_message'])) {
    $flashMessages[] = [
        'type' => 'success',
        'text' => htmlspecialchars($_SESSION['success_message'])
    ];
    unset($_SESSION['success_message']);
}

// Fungsi helper untuk memotong teks
if (!function_exists('truncateText')) {
    function truncateText(string $text, int $maxLength = 150): string {
        if (strlen($text) > $maxLength) {
            $text = substr($text, 0, $maxLength);
            // Pastikan tidak memotong di tengah kata
            $lastSpace = strrpos($text, ' ');
            if ($lastSpace !== false) {
                $text = substr($text, 0, $lastSpace);
            }
            $text .= '...';
        }
        return $text;
    }
}

// Cek apakah user adalah admin
$is_admin = (isset($_SESSION['user_role']) && $_SESSION['user_role'] === 'admin'); // Sesuaikan 'admin' dengan role yang kamu gunakan
?>

<style>
/* Gaya dasar untuk notifikasi */
.notification-container {
    position: fixed; /* Atau 'absolute' jika ingin di dalam elemen tertentu */
    top: 20px; /* Jarak dari atas */
    left: 50%;
    transform: translateX(-50%);
    z-index: 1050; /* Pastikan di atas elemen lain, misal modal */
    width: 100%;
    max-width: 500px; /* Lebar maksimum notifikasi */
    padding: 0 15px; /* Padding samping untuk tampilan mobile */
    pointer-events: none; /* Agar tidak menghalangi klik di bawahnya */
}

.notification {
    padding: 15px 20px;
    margin-bottom: 15px; /* Jarak antar notifikasi jika ada beberapa */
    border-radius: 8px;
    text-align: center;
    font-weight: bold;
    opacity: 1;
    transition: opacity 0.5s ease-in-out, transform 0.5s ease-in-out; /* Tambah transisi untuk transform */
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
    pointer-events: auto; /* Aktifkan pointer events untuk notifikasi itu sendiri */
    position: relative; /* Untuk posisi tombol tutup */
}

/* Gaya untuk pesan sukses */
.notification.success {
    background-color: #d4edda; /* Hijau muda */
    color: #155724; /* Teks hijau tua */
    border: 1px solid #c3e6cb; /* Border hijau */
}

/* Gaya untuk pesan error */
.notification.error {
    background-color: #f8d7da; /* Merah muda */
    color: #721c24; /* Teks merah tua */
    border: 1px solid #f5c6cb; /* Border merah */
}

/* Gaya untuk tombol tutup (opsional) */
.notification .close-btn {
    position: absolute;
    top: 5px;
    right: 10px;
    font-size: 1.5em;
    line-height: 1;
    color: inherit;
    cursor: pointer;
    background: none;
    border: none;
    padding: 0;
    opacity: 0.7;
}

.notification .close-btn:hover {
    opacity: 1;
    color: #000; /* Atau warna yang lebih gelap */
}

/* Styling tambahan untuk gambar film di featured section */
.icon-box .icon img {
    width: 100%;
    height: 180px; /* Tinggi tetap untuk cover */
    object-fit: cover; /* Pastikan gambar mengisi area tanpa distorsi */
    border-radius: 4px;
    margin-bottom: 15px; /* Jarak antara gambar dan judul */
}

/* Styling untuk membuat seluruh icon-box bisa diklik */
.icon-box.film-card {
    cursor: pointer;
    transition: transform 0.2s ease-in-out, box-shadow 0.2s ease-in-out;
    padding-bottom: 20px; /* Sesuaikan padding bawah karena tidak ada tombol terpisah */
}

.icon-box.film-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 20px rgba(0, 0, 0, 0.15);
}

.btn-card-bottom-right {
    position: absolute;
    bottom: 20px; /* Jarak dari bawah card */
    right: 20px; /* Jarak dari kanan card */
}

/* Responsive adjustment for icon-box on smaller screens */
@media (max-width: 768px) {
    .notification-container {
        top: 10px;
        max-width: 90%;
    }
    .icon-box .icon img {
        height: 220px; /* Sesuaikan tinggi gambar untuk mobile */
    }
}
</style>

<div id="flash-message-container" class="notification-container">
    </div>

<section id="hero">
    <div class="hero-container">
        <div id="heroCarousel" data-bs-interval="5000" class="carousel slide carousel-fade" data-bs-ride="carousel">

            <ol class="carousel-indicators" id="hero-carousel-indicators"></ol>

            <div class="carousel-inner" role="listbox">

                <div class="carousel-item active" style="background-image: url(assets/img/slide/slide-1.jpg);">
                    <div class="carousel-container">
                        <div class="carousel-content">
                            <h2 class="animate__animated animate__fadeInDown">Selamat Datang di <span>Cinema SI</span></h2>
                            <p class="animate__animated animate__fadeInUp">Aplikasi Ticketing Bioskop Film terbaru dan terbaik pilihan kamu !</p>
                            <a href="index.php?hal=film" class="btn-get-started animate__animated animate__fadeInUp">Lihat Film</a>
                        </div>
                    </div>
                </div>

                <div class="carousel-item" style="background-image: url(assets/img/slide/slide-2.jpg);">
                    <div class="carousel-container">
                        <div class="carousel-content">
                            <h2 class="animate__animated animate__fadeInDown">Film Terbaru <span>Spider-Man: No Way Home</span></h2>
                            <p class="animate__animated animate__fadeInUp">Film ini merupakan sekuel dari Spider-Man: Homecoming (2017) dan Spider-Man: Far From Home (2019), serta film ke-27 di Marvel Cinematic Universe (MCU).</p>
                            <a href="index.php?hal=film" class="btn-get-started animate__animated animate__fadeInUp">Lihat Film</a>
                        </div>
                    </div>
                </div>

                <div class="carousel-item" style="background-image: url(assets/img/slide/slide-3.jpg);">
                    <div class="carousel-container">
                        <div class="carousel-content">
                            <h2 class="animate__animated animate__fadeInDown">Film Terbaru <span>PARASITE</span></h2>
                            <p class="animate__animated animate__fadeInUp">PARASITE adalah film yang mengikuti keluarga Kim, sebuah keluarga miskin yang hidup dalam kemelaratan di sebuah semi-basement yang kumuh.</p>
                            <a href="index.php?hal=film" class="btn-get-started animate__animated animate__fadeInUp">Lihat Film</a>
                        </div>
                    </div>
                </div>

            </div>

            <a class="carousel-control-prev" href="#heroCarousel" role="button" data-bs-slide="prev">
                <span class="carousel-control-prev-icon bi bi-chevron-left" aria-hidden="true"></span>
            </a>

            <a class="carousel-control-next" href="#heroCarousel" role="button" data-bs-slide="next">
                <span class="carousel-control-next-icon bi bi-chevron-right" aria-hidden="true"></span>
            </a>

        </div>
    </div>
</section>
<main id="main">

    <section id="featured" class="featured">
        <div class="container">
            <div class="row">
                <?php if ($is_admin): // Jika admin, tampilkan card aksi cepat ?>
                    <div class="col-lg-4 col-md-6 d-flex align-items-stretch mb-4">
                        <div class="icon-box">
                            <div class="icon"><i class="bi bi-film"></i></div>
                            <h4><a href="index.php?hal=film">Kelola Film</a></h4>
                            <p>Tambahkan, edit, atau hapus data film yang tayang di bioskop.</p>
                            <a href="index.php?hal=film" class="btn btn-primary btn-sm btn-card-bottom-right">Pergi ke Halaman Film</a>
                        </div>
                    </div>

                    <div class="col-lg-4 col-md-6 d-flex align-items-stretch mb-4">
                        <div class="icon-box">
                            <div class="icon"><i class="bi bi-calendar-event"></i></div>
                            <h4><a href="index.php?hal=jadwal">Kelola Jadwal Tayang</a></h4>
                            <p>Atur jadwal tayang film di berbagai studio dan waktu.</p>
                            <a href="index.php?hal=jadwal" class="btn btn-primary btn-sm btn-card-bottom-right">Pergi ke Halaman Jadwal</a>
                        </div>
                    </div>

                    <div class="col-lg-4 col-md-6 d-flex align-items-stretch mb-4">
                        <div class="icon-box">
                            <div class="icon"><i class="bi bi-ticket-perforated"></i></div>
                            <h4><a href="index.php?hal=pesanan">Lihat Pesanan Tiket</a></h4>
                            <p>Pantau daftar pesanan tiket yang sudah dibuat pengguna.</p>
                            <a href="index.php?hal=pemesanan_all" class="btn btn-primary btn-sm btn-card-bottom-right">Pergi ke Halaman Pesanan</a>
                        </div>
                    </div>
                <?php else: // Jika bukan admin, tampilkan daftar film, dan seluruh card bisa diklik ?>
                    <?php
                    // Variabel $films akan datang dari controller
                    if (!empty($films)) {
                        foreach($films as $row){
                    ?>
                            <div class="col-lg-4 col-md-6 d-flex align-items-stretch mb-4">
                                <div class="icon-box film-card" data-url="index.php?hal=film_detail&id=<?= htmlspecialchars($row['id']) ?>">
                                    <div class="icon">
                                        <?php if ($row['cover']): ?>
                                            <img src="assets/img/film_covers/<?= htmlspecialchars(basename($row['cover'])) ?>" alt="<?= htmlspecialchars($row['judul']) ?>" class="img-fluid">
                                        <?php else: ?>
                                            <div style="width: 100%; height: 180px; background-color: #f0f0f0; display: flex; align-items: center; justify-content: center; border-radius: 4px; font-size: 0.8em; color: #aaa;">No Cover</div>
                                        <?php endif; ?>
                                    </div>
                                    <h4><?= htmlspecialchars($row['judul']) ?></h4>
                                    <p><?= truncateText(htmlspecialchars($row['sinopsis']), 150) ?></p>
                                    </div>
                            </div>
                    <?php
                        }
                    } else {
                        echo '<div class="col-12"><div class="alert alert-info text-center">Belum ada data film tersedia untuk ditampilkan.</div></div>';
                    }
                    ?>
                <?php endif; ?>
            </div>
        </div>
    </section>

    <section id="counts" class="counts">
        <div class="container">
            <div class="row no-gutters">

                <div class="col-lg-3 col-md-6 d-md-flex align-items-stretch">
                    <div class="count-box">
                        <i class="bi bi-emoji-smile"></i>
                        <span data-purecounter-start="0" data-purecounter-end="<?= htmlspecialchars($total_users ?? 0) ?>" data-purecounter-duration="1" class="purecounter"></span>
                        <p><strong>User</strong> Bioskop</p>
                        <a href="index.php?hal=user">Find out more »</a>
                    </div>
                </div>

                <div class="col-lg-3 col-md-6 d-md-flex align-items-stretch">
                    <div class="count-box">
                        <i class="bi bi-journal-richtext"></i>
                        <span data-purecounter-start="0" data-purecounter-end="<?= htmlspecialchars($total_studios ?? 0) ?>" data-purecounter-duration="1" class="purecounter"></span>
                        <p><strong>Studio</strong> Bioskop</p>
                        <a href="index.php?hal=studio">Find out more »</a>
                    </div>
                </div>

                <div class="col-lg-3 col-md-6 d-md-flex align-items-stretch">
                    <div class="count-box">
                        <i class="bi bi-headset"></i>
                        <span data-purecounter-start="0" data-purecounter-end="<?= htmlspecialchars($total_kategoris ?? 0) ?>" data-purecounter-duration="1" class="purecounter"></span>
                        <p><strong>Kategori</strong> Film Bioskop</p>
                        <a href="index.php?hal=kategori">Find out more »</a>
                    </div>
                </div>

                <div class="col-lg-3 col-md-6 d-md-flex align-items-stretch">
                    <div class="count-box">
                        <i class="bi bi-people"></i>
                        <span data-purecounter-start="0" data-purecounter-end="<?= htmlspecialchars($total_films ?? 0) ?>" data-purecounter-duration="1" class="purecounter"></span>
                        <p><strong>Film</strong>Bioskop</p>
                        <a href="index.php?hal=film">Find out more »</a>
                    </div>
                </div>

            </div>
        </div>
    </section>

    <section id="about" class="about">
        <div class="container">

            <div class="row">
                <div class="col-lg-6">
                    <img src="assets/img/about.jpg" class="img-fluid" alt="">
                </div>
                <div class="col-lg-6 pt-4 pt-lg-0 content">
                    <h3>Sistem Pemesanan Tiket Bioskop</h3>
                    <p>Bekasi, Jawa Barat</p>
                    <p class="fst-italic">
                        Aplikasi ini menyediakan beberapa informasi mengenai film terbaru dan sebagainya.
                    </p>
                    <ul>
                        <li><i class="bi bi-check-circle"></i> Terdapat beberapa pilihan film terbaru</li>
                        <li><i class="bi bi-check-circle"></i> Pemesanan tiket lebih mudah</li>
                        <li><i class="bi bi-check-circle"></i> Terdapat berbagai studio dan tiket dengan harga terjangkau</li>
                    </ul>
                    <p>
                        Nikmati film dan hiburan terbaik, tetap terbaru dengan berita terbaru, dan dapatkan penawaran dan promo menarik!
                        Pilihan film online terbaru dan seru buat kamu!, terdapat promo promo menarik juga lohhh,,,
                    </p>
                    <p>yukk tunggu apalagi pesan tiket mu sekarang !!</p>
                </div>
            </div>

        </div>
    </section>

    <section id="services" class="services section-bg">
        <div class="container">

            <div class="section-title">
                <h2>Services</h2>
                <p>Kami menyediakan berbagai fitur untuk kenyamanan Anda dalam memesan tiket bioskop.</p>
            </div>

            <div class="row">
                <div class="col-lg-4 col-md-6 icon-box">
                    <div class="icon"><i class="bi bi-cash-stack"></i></div>
                    <h4 class="title"><a href="#">Harga Terjangkau</a></h4>
                    <p class="description">Menyediakan tiket dengan harga yang kompetitif dan terjangkau untuk semua kalangan.</p>
                </div>
                <div class="col-lg-4 col-md-6 icon-box">
                    <div class="icon"><i class="bi bi-card-checklist"></i></div>
                    <h4 class="title"><a href="#">Pilihan Film Beragam</a></h4>
                    <p class="description">Berbagai genre film terbaru dan terpopuler tersedia untuk Anda pilih.</p>
                </div>
                <div class="col-lg-4 col-md-6 icon-box">
                    <div class="icon"><i class="bi bi-calendar4-week"></i></div>
                    <h4 class="title"><a href="#">Jadwal Fleksibel</a></h4>
                    <p class="description">Pilihan jadwal tayang yang beragam, sesuai dengan waktu luang Anda.</p>
                </div>
                <div class="col-lg-4 col-md-6 icon-box">
                    <div class="icon"><i class="bi bi-easel"></i></div>
                    <h4 class="title"><a href="#">Studio Nyaman</a></h4>
                    <p class="description">Nikmati pengalaman menonton di studio yang bersih dan nyaman.</p>
                </div>
                <div class="col-lg-4 col-md-6 icon-box">
                    <div class="icon"><i class="bi bi-globe-americas"></i></div>
                    <h4 class="title"><a href="#">Akses Mudah</a></h4>
                    <p class="description">Pemesanan tiket dapat dilakukan kapan saja dan di mana saja melalui aplikasi.</p>
                </div>
                <div class="col-lg-4 col-md-6 icon-box">
                    <div class="icon"><i class="bi bi-people"></i></div>
                    <h4 class="title"><a href="#">Layanan Pelanggan</a></h4>
                    <p class="description">Tim dukungan pelanggan siap membantu Anda jika ada pertanyaan atau masalah.</p>
                </div>
            </div>

        </div>
    </section>

    <section id="team" class="team">
        <div class="container">

            <div class="section-title">
                <h2>Our Team</h2>
                <p>Tim pengembang aplikasi RR_TiketBioskop.</p>
            </div>

            <div class="row justify-content-center">

                <div class="col-lg-4 col-md-6 d-flex align-items-stretch">
                    <div class="member">
                        <img src="assets/img/team/team-4.jpg" alt="Rafif Profile">
                        <h4>Rafif</h4>
                        <span>Project Lead</span>
                        <p>
                            Bertanggung jawab atas koordinasi proyek dan memastikan semua berjalan lancar.
                        </p>
                        <div class="social">
                            <a href=""><i class="bi bi-twitter"></i></a>
                            <a href=""><i class="bi bi-facebook"></i></a>
                            <a href=""><i class="bi bi-instagram"></i></a>
                            <a href=""><i class="bi bi-linkedin"></i></a>
                        </div>
                    </div>
                </div>

                <div class="col-lg-4 col-md-6 d-flex align-items-stretch">
                    <div class="member">
                        <img src="assets/img/team/team-5.jpg" alt="Dessy Profile">
                        <h4>Dessy</h4>
                        <span>UI/UX Designer</span>
                        <p>
                            Mendesain antarmuka pengguna agar aplikasi mudah digunakan dan menarik secara visual.
                        </p>
                        <div class="social">
                            <a href=""><i class="bi bi-twitter"></i></a>
                            <a href=""><i class="bi bi-facebook"></i></a>
                            <a href=""><i class="bi bi-instagram"></i></a>
                            <a href=""><i class="bi bi-linkedin"></i></a>
                        </div>
                    </div>
                </div>

            </div>

        </div>
    </section>
</main>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // --- Logika Notifikasi ---
    const flashMessages = <?php echo json_encode($flashMessages); ?>;
    const notificationContainer = document.getElementById('flash-message-container');

    flashMessages.forEach(message => {
        const notificationDiv = document.createElement('div');
        notificationDiv.classList.add('notification', message.type);
        notificationDiv.textContent = message.text;

        // Tambahkan tombol tutup opsional
        const closeBtn = document.createElement('button');
        closeBtn.classList.add('close-btn');
        closeBtn.innerHTML = '&times;'; // Simbol 'x'
        closeBtn.setAttribute('aria-label', 'Close');
        closeBtn.addEventListener('click', function() {
            notificationDiv.style.opacity = '0';
            notificationDiv.addEventListener('transitionend', () => {
                notificationDiv.remove();
            });
        });
        notificationDiv.appendChild(closeBtn);

        notificationContainer.appendChild(notificationDiv);

        // Otomatis hilangkan notifikasi setelah 5 detik
        setTimeout(() => {
            notificationDiv.style.opacity = '0';
            notificationDiv.addEventListener('transitionend', () => {
                notificationDiv.remove();
            });
        }, 5000); // Pesan akan hilang setelah 5 detik
    });

    // --- Logika Card Film Clickable ---
    const filmCards = document.querySelectorAll('.icon-box.film-card');
    filmCards.forEach(card => {
        card.addEventListener('click', function() {
            const url = this.dataset.url; // Ambil URL dari data-url attribute
            if (url) {
                window.location.href = url; // Navigasi ke URL
            }
        });
    });
});
</script>