<?php
// views/form_pemesanan.php
// View ini digunakan untuk menampilkan detail jadwal dan peta kursi untuk pemesanan.
// Variabel yang diharapkan:
// - $jadwal_detail (array asosiatif detail jadwal tayang)
// - $kursi_status (array asosiatif daftar kursi dengan status ketersediaan)
// Variabel-variabel ini disediakan oleh PemesananController->showForm()

// Pesan sukses atau error dari sesi
if (isset($_SESSION['error_message'])) {
    echo "<p class='message error'>" . htmlspecialchars($_SESSION['error_message']) . "</p>";
    unset($_SESSION['error_message']);
}
if (isset($_SESSION['success_message'])) {
    echo "<p class='message success'>" . htmlspecialchars($_SESSION['success_message']) . "</p>";
    unset($_SESSION['success_message']);
}

// Pastikan $jadwal_detail tidak kosong
if (!isset($jadwal_detail) || !is_array($jadwal_detail)) {
    echo "<p class='message error'>Jadwal tayang tidak ditemukan.</p>";
    return; // Hentikan eksekusi jika data jadwal tidak ada
}

// Transformasi $kursi_status menjadi map yang lebih mudah diakses
$kursi_map = [];
foreach ($kursi_status as $kursi) {
    $kursi_map[$kursi['nomor']] = $kursi;
}

// Definisikan layout kursi 5x5
$rows = ['A', 'B', 'C', 'D', 'E'];
$cols = [1, 2, 3, 4, 5];

// Tentukan total harga awal dan kursi yang dipilih (akan diupdate oleh JS)
$total_harga_awal = 0;
$kursi_terpilih_awal = [];
?>

<div class="main-booking-wrapper">
    <h1 class="main-title">Pesan Tiket Bioskop</h1>
    <p class="intro-text">
        Pilih kursi terbaik Anda untuk pengalaman menonton yang tak terlupakan!
    </p>

    <div class="info-and-seat-section movie-info-section">
        <h3>Detail Pemesanan Anda</h3>
        <p><strong>Film:</strong> <span class="detail-highlight"><?php echo htmlspecialchars($jadwal_detail['film_judul']); ?></span></p>
        <p><strong>Studio:</strong> <span class="detail-highlight"><?php echo htmlspecialchars($jadwal_detail['studio_nama']); ?></span></p>
        <p><strong>Tanggal:</strong> <span class="detail-highlight"><?php echo htmlspecialchars($jadwal_detail['tanggal_tayang']); ?></span></p>
        <p><strong>Waktu:</strong> <span class="detail-highlight"><?php echo htmlspecialchars(substr($jadwal_detail['waktu_tayang'], 0, 5)); ?> WIB</span></p>
        <p class="ticket-price-display"><strong>Harga Tiket per Kursi:</strong> <span class="price-amount">Rp <?php echo number_format($jadwal_detail['harga_tiket'], 0, ',', '.'); ?></span></p>
    </div>

    <div class="info-and-seat-section seat-selection-section">
        <h2 class="section-title seat-selection-sub-title">Silakan Pilih Kursi Anda</h2>
        <p class="instruction-text">
            Klik pada kursi yang berwarna abu-abu terang (Regular) untuk memilihnya. Kursi yang sudah terisi berwarna abu-abu gelap.
        </p>

        <div class="legend-container">
            <div class="legend-item"><span class="legend-box regular"></span> Regular</div>
            <div class="legend-item"><span class="legend-box unavailable"></span> Tidak Tersedia</div>
            <div class="legend-item"><span class="legend-box chosen"></span> Pilihanmu</div>
        </div>

        <form action="index.php?hal=pemesanan_process" method="POST" class="pemesanan-form" id="pemesanan-form">
            <input type="hidden" name="jadwal_id" value="<?php echo htmlspecialchars($jadwal_detail['id']); ?>">
            <input type="hidden" id="total_price_input" name="total_price" value="0">
            <input type="hidden" id="selected_seats_input" name="selected_seats_numbers" value="">
            <input type="hidden" id="payment_method_input" name="payment_method" value=""> <div class="seat-map-wrapper">
                <div class="screen-indicator">LAYAR BIOSKOP</div>
                <div class="seat-grid">
                    <?php
                    foreach ($rows as $row_char) {
                        foreach ($cols as $col_num) {
                            $seat_name = $row_char . $col_num;
                            $kursi = $kursi_map[$seat_name] ?? ['id' => null, 'nomor' => $seat_name, 'status' => 'unavailable'];

                            $isDisabled = ($kursi['status'] === 'booked' || $kursi['id'] === null) ? 'disabled' : '';
                            $dataSeatId = ($kursi['id'] !== null) ? htmlspecialchars($kursi['id']) : '';

                            $class = '';
                            if ($kursi['status'] === 'booked') {
                                $class = 'seat-occupied';
                            } elseif ($kursi['id'] === null) {
                                $class = 'seat-aisle';
                                $isDisabled = 'disabled';
                            } else {
                                $class = 'seat-available';
                            }

                            echo "<label class='seat-label " . ($isDisabled ? 'disabled-label' : '') . "'>";
                            echo "<input type='checkbox' name='kursi_ids[]' value='" . $dataSeatId . "' " . $isDisabled . " data-seat-number='" . htmlspecialchars($kursi['nomor']) . "' data-seat-price='" . htmlspecialchars($jadwal_detail['harga_tiket']) . "'>";
                            echo "<span class='seat " . $class . "'>";
                            echo ($class === 'seat-aisle') ? '' : htmlspecialchars($kursi['nomor']);
                            echo "</span>";
                            echo "</label>";
                        }
                    }
                    ?>
                </div>
            </div>

            <div class="payment-method-section">
                <h3>Pilih Metode Pembayaran</h3>
                <p class="instruction-text">Pilih salah satu metode di bawah ini untuk melanjutkan.</p>

                <div class="payment-options">
                    <label class="payment-option-label">
                        <input type="radio" name="payment_method_radio" value="debit_card">
                        <span class="payment-method-tile">
                            <span class="payment-icon">💳</span> Kartu Debit
                        </span>
                    </label>
                    <label class="payment-option-label">
                        <input type="radio" name="payment_method_radio" value="ewallet">
                        <span class="payment-method-tile">
                            <span class="payment-icon">📱</span> Semua E-Wallet
                        </span>
                    </label>
                    <label class="payment-option-label">
                        <input type="radio" name="payment_method_radio" value="cash">
                        <span class="payment-method-tile">
                            <span class="payment-icon">💵</span> Tunai (Cash)
                        </span>
                    </label>
                    <label class="payment-option-label">
                        <input type="radio" name="payment_method_radio" value="qris">
                        <span class="payment-method-tile">
                            <span class="payment-icon">📷</span> QRIS
                        </span>
                    </label>
                </div>
                <p id="payment-method-warning" class="message error hidden">
                    Silakan pilih metode pembayaran sebelum melanjutkan.
                </p>
            </div>

            <div class="summary-bar-inline">
                <div class="summary-item">
                    <span class="summary-label">TOTAL HARGA</span>
                    <span class="summary-value total-price">Rp0</span>
                </div>
                <div class="summary-item">
                    <span class="summary-label">TEMPAT DUDUK</span>
                    <span class="summary-value selected-seats-display"></span>
                </div>
                <button type="submit" class="confirm-order-button" disabled>
                    RINGKASAN ORDER (<span id="selected-seat-count">0</span>)
                </button>
            </div>
        </form>
    </div>
</div>

<div id="paymentSuccessOverlay" class="payment-success-overlay">
    <div class="success-content">
        <div class="checkmark-circle">
            <div class="checkmark stem"></div>
            <div class="checkmark kick"></div>
        </div>
        <h2>Pembayaran Berhasil!</h2>
        <p>Tiket Anda telah berhasil dipesan.</p>
        <p>Anda akan diarahkan ke halaman riwayat pemesanan...</p>
    </div>
</div>

<style>
    /* Reset & Base Styles */
    body {
        margin: 0;
        font-family: 'Poppins', sans-serif;
        background-color: #f0f2f5;
        color: #333;
        line-height: 1.6;
        overflow-x: hidden;
    }

    /* Helper Class */
    .hidden {
        display: none !important;
    }

    /* Message Styling (Success/Error) */
    .message {
        padding: 10px 20px;
        margin: 15px auto;
        border-radius: 5px;
        text-align: center;
        font-weight: bold;
        max-width: 600px;
        box-sizing: border-box;
        animation: slideIn 0.5s ease-out;
    }

    @keyframes slideIn {
        from { opacity: 0; transform: translateY(-20px); }
        to { opacity: 1; transform: translateY(0); }
    }

    .message.error {
        background-color: #f8d7da;
        color: #721c24;
        border: 1px solid #f5c6cb;
    }

    .message.success {
        background-color: #d4edda;
        color: #155724;
        border: 1px solid #c3e6cb;
    }

    /* Main Wrapper for overall layout */
    .main-booking-wrapper {
        max-width: 850px;
        margin: 40px auto 40px auto;
        display: flex;
        flex-direction: column;
        gap: 30px;
        align-items: center;
    }

    /* Titles and Information Text */
    .main-title {
        text-align: center;
        color: #1a2a3a;
        font-size: 2.8em;
        font-weight: 800;
        margin-bottom: 10px;
        letter-spacing: -1px;
        text-transform: uppercase;
        position: relative;
        padding-bottom: 10px;
        width: 100%;
    }
    .main-title::after {
        content: '';
        width: 80px;
        height: 4px;
        background-color: #007bff;
        position: absolute;
        bottom: 0;
        left: 50%;
        transform: translateX(-50%);
        border-radius: 2px;
    }

    .intro-text {
        text-align: center;
        color: #666;
        font-size: 1.1em;
        margin-bottom: 0;
        line-height: 1.5;
        max-width: 600px;
    }

    /* Shared style for info and seat selection sections */
    .info-and-seat-section {
        background-color: #fff;
        border-radius: 15px;
        box-shadow: 0 8px 20px rgba(0,0,0,0.15);
        padding: 30px;
        width: 100%;
        box-sizing: border-box;
    }

    /* Movie Info Section */
    .movie-info-section h3 {
        text-align: center;
        color: #343a40;
        font-size: 1.4em;
        margin-top: 0;
        margin-bottom: 15px;
        border-bottom: 1px solid #eee;
        padding-bottom: 10px;
    }
    .movie-info-section p {
        margin: 8px 0;
        font-size: 1em;
        color: #495057;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }
    .movie-info-section p strong {
        color: #333;
        min-width: 150px;
        text-align: left;
    }
    .detail-highlight {
        font-weight: 600;
        color: #007bff;
        text-align: right;
        flex-grow: 1;
    }

    .ticket-price-display {
        margin-top: 15px !important;
        padding-top: 10px;
        border-top: 1px dashed #e9ecef;
        font-size: 1.2em !important;
        font-weight: bold;
        color: #28a745 !important;
    }
    .price-amount {
        background-color: #e6ffed;
        padding: 5px 10px;
        border-radius: 5px;
        border: 1px solid #28a745;
        display: inline-block;
        box-shadow: 0 1px 3px rgba(40, 167, 69, 0.2);
    }

    /* Seat Selection Section */
    .seat-selection-sub-title {
        font-size: 2em;
        color: #1a2a3a;
        margin-top: 0;
        margin-bottom: 10px;
        font-weight: 700;
        text-align: center;
    }
    .instruction-text {
        text-align: center;
        color: #777;
        font-size: 1em;
        margin-bottom: 25px;
        max-width: 500px;
        margin-left: auto;
        margin-right: auto;
    }

    /* Legend */
    .legend-container {
        display: flex;
        justify-content: center;
        flex-wrap: wrap;
        gap: 25px;
        margin-bottom: 30px;
        padding: 15px;
        background-color: #f9f9f9;
        border-radius: 10px;
        box-shadow: inset 0 1px 4px rgba(0,0,0,0.05);
    }

    .legend-item {
        display: flex;
        align-items: center;
        font-size: 0.9em;
        color: #555;
        font-weight: 500;
    }

    .legend-box {
        width: 20px;
        height: 20px;
        border-radius: 4px;
        margin-right: 8px;
        border: 1px solid rgba(0,0,0,0.1);
    }

    .legend-box.regular { background-color: #e0e0e0; }
    .legend-box.unavailable { background-color: #b0b0b0; }
    .legend-box.chosen { background-color: #007bff; }

    /* Seat Map Area */
    .pemesanan-form {
        display: flex;
        flex-direction: column;
        align-items: center;
        width: 100%;
    }

    .seat-map-wrapper {
        width: 100%;
        max-width: 350px;
        background-color: #fff;
        border: 1px solid #ddd;
        border-radius: 10px;
        padding: 20px;
        box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        position: relative;
        overflow: hidden;
        margin: 0 auto 30px auto;
    }

    .screen-indicator {
        background: linear-gradient(to right, #ccc, #f5f5f5, #ccc);
        border-radius: 0 0 50% 50% / 0 0 30px 30px;
        height: 30px;
        width: 80%;
        margin: 0 auto 30px auto;
        display: flex;
        justify-content: center;
        align-items: center;
        font-weight: 600;
        color: #555;
        font-size: 0.9em;
        position: relative;
        top: -10px;
        box-shadow: 0 5px 10px rgba(0,0,0,0.05);
    }

    .seat-grid {
        display: grid;
        grid-template-columns: repeat(5, 1fr);
        gap: 10px;
        justify-items: center;
        align-items: center;
    }

    /* Seat Styling */
    .seat-label {
        display: inline-block;
        cursor: pointer;
        user-select: none;
        width: 45px;
        height: 45px;
        display: flex;
        justify-content: center;
        align-items: center;
        position: relative;
    }

    .seat-label input[type='checkbox'] {
        position: absolute;
        opacity: 0;
        width: 0;
        height: 0;
        pointer-events: none;
    }

    .seat {
        display: flex;
        justify-content: center;
        align-items: center;
        width: 100%;
        height: 100%;
        border-radius: 6px;
        font-size: 0.85em;
        font-weight: 500;
        transition: all 0.2s ease;
        box-shadow: 0 1px 3px rgba(0,0,0,0.1);
    }

    .seat-available {
        background-color: #e0e0e0;
        border: 1px solid #d0d0d0;
        color: #555;
    }

    .seat-occupied {
        background-color: #b0b0b0;
        border: 1px solid #a0a0a0;
        color: #777;
        cursor: not-allowed;
        opacity: 1;
    }

    .seat-aisle {
        background-color: transparent;
        border: none;
        box-shadow: none;
        cursor: default;
        font-size: 0.7em;
        color: #aaa;
        font-style: italic;
    }
    .seat-aisle:not(:empty) {
        content: "";
    }
    .seat-aisle::after {
        content: "—";
        display: flex;
        align-items: center;
        justify-content: center;
        width: 100%;
        height: 100%;
    }

    .seat-label input[type='checkbox']:checked + .seat {
        background-color: #007bff !important;
        border-color: #0056b3;
        color: white;
        box-shadow: 0 0 10px rgba(0, 123, 255, 0.5);
        transform: scale(1.05);
    }

    .seat-label input[type='checkbox']:disabled + .seat {
        cursor: not-allowed;
    }

    /* Payment Method Section */
    .payment-method-section {
        width: 100%;
        padding: 20px;
        border-top: 1px solid #eee;
        margin-top: 30px;
        text-align: center;
    }
    .payment-method-section h3 {
        font-size: 1.5em;
        color: #1a2a3a;
        margin-top: 0;
        margin-bottom: 10px;
    }
    .payment-method-section .instruction-text {
        margin-bottom: 20px;
    }
    .payment-options {
        display: flex;
        flex-wrap: wrap;
        justify-content: center;
        gap: 15px;
        margin-bottom: 20px;
    }
    .payment-option-label {
        display: block;
        cursor: pointer;
        user-select: none;
        position: relative;
    }
    .payment-option-label input[type="radio"] {
        position: absolute;
        opacity: 0;
        pointer-events: none;
    }
    .payment-method-tile {
        background-color: #f0f0f0;
        border: 2px solid #ddd;
        border-radius: 10px;
        padding: 15px 20px;
        display: flex;
        flex-direction: column;
        align-items: center;
        min-width: 120px;
        height: 80px;
        justify-content: center;
        font-size: 0.95em;
        font-weight: 600;
        color: #555;
        transition: all 0.2s ease;
        box-shadow: 0 2px 5px rgba(0,0,0,0.08);
    }
    .payment-icon {
        font-size: 2.2em;
        margin-bottom: 5px;
        color: #007bff;
    }

    /* Style for selected payment method */
    .payment-option-label input[type="radio"]:checked + .payment-method-tile {
        background-color: #e6f2ff;
        border-color: #007bff;
        color: #007bff;
        box-shadow: 0 0 12px rgba(0, 123, 255, 0.3);
        transform: translateY(-3px);
    }
    .payment-option-label input[type="radio"]:checked + .payment-method-tile .payment-icon {
        color: #007bff;
    }

    /* Summary Bar */
    .summary-bar-inline {
        background-color: #fff;
        padding: 20px 25px;
        box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        border-radius: 10px;
        margin-top: 30px;
        display: flex;
        justify-content: space-between;
        align-items: center;
        box-sizing: border-box;
        width: 100%;
        border: 1px solid #eee;
    }

    .summary-item {
        display: flex;
        flex-direction: column;
        align-items: flex-start;
        flex-grow: 1;
        max-width: 30%;
    }

    .summary-label {
        font-size: 0.75em;
        color: #888;
        text-transform: uppercase;
        margin-bottom: 3px;
    }

    .summary-value {
        font-size: 1.1em;
        font-weight: bold;
        color: #333;
    }

    .total-price {
        color: #007bff;
        font-size: 1.3em;
    }

    .confirm-order-button {
        background-color: #007bff;
        color: white;
        border: none;
        border-radius: 25px;
        padding: 12px 25px;
        font-size: 1em;
        font-weight: 600;
        cursor: pointer;
        transition: background-color 0.3s ease, opacity 0.3s ease;
        display: flex;
        align-items: center;
        gap: 5px;
    }

    .confirm-order-button:hover:not(:disabled) {
        background-color: #0056b3;
    }
    .confirm-order-button:disabled {
        opacity: 0.6;
        cursor: not-allowed;
    }

    /* NEW: Payment Success Overlay Styles */
    .payment-success-overlay {
        display: none; /* Hidden by default */
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background-color: rgba(255, 255, 255, 0.95); /* Hampir putih solid */
        z-index: 9999; /* Pastikan di atas segalanya */
        /* Removed display: flex here, will be added by .show class */
        flex-direction: column;
        justify-content: center;
        align-items: center;
        text-align: center;
        backdrop-filter: blur(8px); /* Sedikit blur */
        animation: fadeInSuccess 0.5s forwards;
    }

    /* New class to make the overlay visible */
    .payment-success-overlay.show {
        display: flex;
    }

    @keyframes fadeInSuccess {
        from { opacity: 0; }
        to { opacity: 1; }
    }

    .success-content {
        background-color: white;
        padding: 40px;
        border-radius: 15px;
        box-shadow: 0 10px 30px rgba(0, 123, 255, 0.3);
        transform: translateY(20px);
        opacity: 0;
        animation: slideUpFadeIn 0.6s forwards 0.2s; /* Delay animation content */
    }

    @keyframes slideUpFadeIn {
        from { opacity: 0; transform: translateY(20px); }
        to { opacity: 1; transform: translateY(0); }
    }

    .checkmark-circle {
        width: 100px;
        height: 100px;
        border-radius: 50%;
        background-color: #28a745; /* Green */
        display: flex;
        justify-content: center;
        align-items: center;
        margin: 0 auto 30px auto;
        box-shadow: 0 0 20px rgba(40, 167, 69, 0.5);
        animation: scaleIn 0.5s forwards;
    }

    @keyframes scaleIn {
        from { transform: scale(0); opacity: 0; }
        to { transform: scale(1); opacity: 1; }
    }

    .checkmark {
        height: 40px;
        width: 20px;
        border: solid white;
        border-width: 0 5px 5px 0;
        transform: rotate(45deg);
        animation: drawCheckmark 0.5s forwards 0.5s; /* Delay checkmark animation */
        opacity: 0;
    }

    @keyframes drawCheckmark {
        0% { height: 0; width: 0; opacity: 0; }
        100% { height: 40px; width: 20px; opacity: 1; }
    }
    
    .success-content h2 {
        color: #28a745;
        font-size: 2.5em;
        margin-bottom: 15px;
    }

    .success-content p {
        color: #555;
        font-size: 1.1em;
        margin-bottom: 10px;
    }


    /* Responsive Adjustments */
    @media (max-width: 768px) {
        .main-booking-wrapper {
            margin: 20px auto;
            gap: 20px;
            padding: 0 15px;
        }
        .info-and-seat-section {
            padding: 20px;
        }
        .main-title {
            font-size: 2.2em;
        }
        .intro-text {
            font-size: 0.9em;
        }
        .movie-info-section h3 {
            font-size: 1.2em;
        }
        .movie-info-section p {
            font-size: 0.9em;
            flex-direction: column;
            align-items: flex-start;
        }
        .movie-info-section p strong {
            min-width: unset;
            margin-bottom: 5px;
        }
        .detail-highlight {
            text-align: left;
        }
        .ticket-price-display {
            font-size: 1.1em !important;
        }
        .seat-selection-sub-title {
            font-size: 1.6em;
        }
        .instruction-text {
            font-size: 0.9em;
        }
        .legend-container {
            gap: 15px;
            padding: 10px;
        }
        .seat-map-wrapper {
            padding: 15px;
            max-width: 100%;
            margin-bottom: 20px;
        }
        .seat-grid {
            gap: 8px;
        }
        .seat-label, .seat {
            width: 40px;
            height: 40px;
            font-size: 0.8em;
        }
        .payment-method-section {
            padding: 15px;
            margin-top: 20px;
        }
        .payment-method-section h3 {
            font-size: 1.3em;
        }
        .payment-options {
            gap: 10px;
        }
        .payment-method-tile {
            min-width: 100px;
            height: 70px;
            padding: 10px 15px;
            font-size: 0.85em;
        }
        .payment-icon {
            font-size: 1.8em;
        }
        .summary-bar-inline {
            flex-wrap: wrap;
            justify-content: center;
            gap: 10px;
            padding: 10px 15px;
            margin-top: 20px;
        }
        .summary-item {
            flex-basis: 45%;
            align-items: center;
        }
        .confirm-order-button {
            width: 90%;
            margin-top: 10px;
            font-size: 0.9em;
            padding: 10px 20px;
        }
        .checkmark-circle {
            width: 80px;
            height: 80px;
            margin-bottom: 20px;
        }
        .checkmark {
            height: 30px;
            width: 15px;
        }
        .success-content h2 {
            font-size: 2em;
        }
        .success-content p {
            font-size: 1em;
        }
    }

    @media (max-width: 480px) {
        .main-title {
            font-size: 1.8em;
        }
        .seat-grid {
            gap: 5px;
        }
        .seat-label, .seat {
            width: 35px;
            height: 35px;
            font-size: 0.75em;
        }
        .payment-method-tile {
            min-width: 80px;
            height: 60px;
            font-size: 0.8em;
        }
        .payment-icon {
            font-size: 1.5em;
        }
        .summary-item {
            flex-basis: 100%;
        }
        .checkmark-circle {
            width: 60px;
            height: 60px;
        }
        .checkmark {
            height: 25px;
            width: 12px;
        }
        .success-content h2 {
            font-size: 1.5em;
        }
        .success-content p {
            font-size: 0.9em;
        }
    }
</style>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const seatCheckboxes = document.querySelectorAll('.seat-label input');
        const paymentMethodRadios = document.querySelectorAll('input[name="payment_method_radio"]');
        const confirmButton = document.querySelector('.confirm-order-button');
        const paymentMethodWarning = document.getElementById('payment-method-warning');

        const totalPriceDisplay = document.querySelector('.total-price');
        const selectedSeatsDisplay = document.querySelector('.selected-seats-display');
        const selectedSeatCount = document.getElementById('selected-seat-count');
        const totalPriceInput = document.getElementById('total_price_input');
        const selectedSeatsInput = document.getElementById('selected_seats_input');
        const paymentMethodInput = document.getElementById('payment_method_input');
        
        // Payment Success Overlay elements
        const paymentSuccessOverlay = document.getElementById('paymentSuccessOverlay');

        let selectedSeats = new Map(); // Map untuk menyimpan nomor kursi dan harganya
        let selectedPaymentMethod = null;

        function updateSummaryAndButtonStatus() {
            let total = 0;
            let seatNumbers = [];

            selectedSeats.forEach((price, number) => {
                total += price;
                seatNumbers.push(number);
            });

            totalPriceDisplay.textContent = 'Rp' + new Intl.NumberFormat('id-ID').format(total);
            selectedSeatsDisplay.textContent = seatNumbers.join(', ');
            selectedSeatCount.textContent = selectedSeats.size;

            totalPriceInput.value = total;
            selectedSeatsInput.value = seatNumbers.join(',');
            paymentMethodInput.value = selectedPaymentMethod; // Update hidden input untuk metode pembayaran

            // Logic untuk mengaktifkan/menonaktifkan tombol konfirmasi
            if (selectedSeats.size > 0 && selectedPaymentMethod) {
                confirmButton.disabled = false;
                paymentMethodWarning.classList.add('hidden'); // Sembunyikan peringatan
            } else {
                confirmButton.disabled = true;
                // Tampilkan peringatan jika kursi sudah dipilih tapi metode bayar belum
                if (selectedSeats.size > 0 && !selectedPaymentMethod) {
                    paymentMethodWarning.classList.remove('hidden');
                } else {
                    paymentMethodWarning.classList.add('hidden');
                }
            }
        }

        seatCheckboxes.forEach(checkbox => {
            checkbox.addEventListener('change', function() {
                const seatNumber = this.dataset.seatNumber;
                const seatPrice = parseFloat(this.dataset.seatPrice);
                const seatSpan = this.nextElementSibling;

                if (this.checked) {
                    selectedSeats.set(seatNumber, seatPrice);
                    seatSpan.classList.add('selected');
                } else {
                    selectedSeats.delete(seatNumber);
                    seatSpan.classList.remove('selected');
                }
                updateSummaryAndButtonStatus();
            });
        });

        paymentMethodRadios.forEach(radio => {
            radio.addEventListener('change', function() {
                selectedPaymentMethod = this.value;
                updateSummaryAndButtonStatus();
            });
        });

        // Event listener untuk tombol submit (untuk validasi tambahan di client-side)
        confirmButton.addEventListener('click', function(event) {
            // Mencegah form submit default untuk menampilkan animasi
            event.preventDefault(); 

            if (selectedSeats.size === 0) {
                alert('Silakan pilih setidaknya satu kursi!'); // Tetap pakai alert untuk validasi ini
                return; // Stop execution
            } else if (!selectedPaymentMethod) {
                paymentMethodWarning.classList.remove('hidden'); // Tampilkan peringatan
                alert('Silakan pilih metode pembayaran!'); // Tetap pakai alert untuk validasi ini
                return; // Stop execution
            }

            // Jika semua validasi dilewati, tampilkan animasi pembayaran berhasil
            paymentSuccessOverlay.classList.add('show'); // Tambahkan kelas 'show' untuk menampilkan overlay
            
            // Setelah animasi selesai (misal 3 detik), submit form dan redirect
            setTimeout(() => {
                document.getElementById('pemesanan-form').submit(); // Submit form
                // Halaman akan di-redirect oleh controller setelah submit berhasil
            }, 3000); // Durasi animasi + sedikit jeda (misal 3 detik)
        });

        // Initial update on page load
        updateSummaryAndButtonStatus();
    });
</script>