<?php
// models/Tiket.php

// Untuk memastikan class berada di global namespace
namespace {
    class Tiket{
        private $koneksi;
        public function __construct(){
            global $dbh; // Pastikan $dbh ini sudah terdefinisi dan merupakan objek PDO yang valid dari koneksi.php
            $this->koneksi = $dbh;
        }
        
        // Metode untuk mengambil semua data tiket dengan detail terkait
        public function dataTiket(){
            $sql = "SELECT t.*, k.nomor AS nomor_kursi, f.judul AS judul_film, s.nama AS nama_studio
                    FROM tiket t 
                    INNER JOIN kursi k ON k.id = t.kursi_id
                    INNER JOIN film f ON f.id = t.film_id
                    INNER JOIN studio s ON s.id = k.studio_id
                    ORDER BY t.id DESC";
            $ps = $this->koneksi->prepare($sql);
            $ps->execute();
            $rs = $ps->fetchAll(PDO::FETCH_ASSOC); 
            return $rs;   
        }

        // Metode untuk mengambil satu data tiket berdasarkan ID
        public function getTiket($id){
            $sql = "SELECT t.*, k.nomor AS nomor_kursi, f.judul AS judul_film, s.nama AS nama_studio
                    FROM tiket t 
                    INNER JOIN kursi k ON k.id = t.kursi_id
                    INNER JOIN film f ON f.id = t.film_id
                    INNER JOIN studio s ON s.id = k.studio_id
                    WHERE t.id = ?";
            $ps = $this->koneksi->prepare($sql);
            $ps->execute([$id]);
            $rs = $ps->fetch(PDO::FETCH_ASSOC); 
            return $rs;   
        }

        // Metode untuk mengambil ID kursi yang sudah dipesan untuk jadwal tertentu
        public function getBookedSeatIdsForJadwal($film_id, $studio_id, $tanggal, $waktu){
            // Query ini disesuaikan berdasarkan diskusi kita (menggunakan detail_pemesanan)
            $sql = "
                SELECT DISTINCT t.kursi_id
                FROM detail_pemesanan dp
                INNER JOIN tiket t ON dp.tiket_id = t.id
                INNER JOIN kursi k ON t.kursi_id = k.id
                INNER JOIN jadwal j ON j.film_id = t.film_id 
                                   AND j.studio_id = k.studio_id 
                                   AND j.tanggal = ? 
                                   AND j.waktu = ?
                WHERE t.film_id = ? 
                AND k.studio_id = ? 
                AND j.tanggal = ? 
                AND j.waktu = ?
            ";
            
            try {
                $ps = $this->koneksi->prepare($sql);
                // Urutan parameter: tanggal, waktu, film_id, studio_id, tanggal, waktu
                $ps->execute([$tanggal, $waktu, $film_id, $studio_id, $tanggal, $waktu]);
                $booked_data = $ps->fetchAll(PDO::FETCH_ASSOC);
                
                return array_map('strval', array_column($booked_data, 'kursi_id')); 
            } catch (PDOException $e) {
                // Log error jika ada masalah saat mengambil data kursi terbooking
                error_log("ERROR (Tiket Model): Gagal mengambil booked seats. Pesan: " . $e->getMessage());
                return [];
            }
        }
        
        // Metode untuk mengambil tiket yang tersedia untuk film dan studio tertentu
        public function getTicketsByFilmAndStudio($film_id, $studio_id){
            $sql = "SELECT t.id AS tiket_id, t.harga, t.stok, t.kursi_id, k.nomor AS nomor_kursi
                    FROM tiket t
                    INNER JOIN kursi k ON t.kursi_id = k.id
                    WHERE t.film_id = ? AND k.studio_id = ? AND t.stok > 0
                    ORDER BY k.nomor ASC";
            
            try {
                $ps = $this->koneksi->prepare($sql);
                $ps->execute([$film_id, $studio_id]);
                $rs = $ps->fetchAll(PDO::FETCH_ASSOC);
                return $rs;
            } catch (PDOException $e) {
                // Log error jika ada masalah saat mengambil data tiket
                error_log("ERROR (Tiket Model): Gagal mengambil tickets by film and studio. Pesan: " . $e->getMessage());
                return [];
            }
        }

        // Metode untuk menyimpan data tiket baru
        public function simpan($data){
            $sql = "INSERT INTO tiket (harga, stok, kursi_id, film_id) VALUES (?,?,?,?)";
            $ps = $this->koneksi->prepare($sql);
            return $ps->execute($data);   
        }

        // Metode untuk mengubah data tiket yang sudah ada
        public function ubah($data){
            $sql = "UPDATE tiket SET harga=?, stok=?, kursi_id=?, film_id=?
                    WHERE id=?";
            $ps = $this->koneksi->prepare($sql);
            return $ps->execute($data);   
        }

        // Metode untuk menghapus data tiket
        public function hapus($id){
            $sql = "DELETE FROM tiket WHERE id=?";
            $ps = $this->koneksi->prepare($sql);
            return $ps->execute([$id]);   
        }
    }
}
?>