<?php
// controllers/RegisterController.php

// Memastikan model Users di-include agar bisa digunakan
require_once dirname(__DIR__) . '/models/Users.php';
// Pastikan BaseController di-include
require_once dirname(__DIR__) . '/controllers/BaseController.php';

// Pastikan kelas ini mewarisi dari BaseController
class RegisterController extends BaseController {

    /**
     * Konstruktor untuk RegisterController.
     * Menerima objek koneksi MySQLi dan meneruskannya ke BaseController.
     * @param mysqli $conn Objek koneksi database MySQLi.
     */
    public function __construct(mysqli $conn) {
        // Panggil konstruktor parent (BaseController) untuk menginisialisasi $this->conn
        parent::__construct($conn);
    }

    /**
     * Menampilkan formulir pendaftaran pengguna baru.
     * Jika pengguna sudah login, akan diarahkan ke halaman utama.
     */
    public function create() {
        // Cek apakah user sudah login, jika ya, arahkan ke home
        if (isset($_SESSION['user_id'])) {
            $this->redirect('home'); // Menggunakan redirect dari BaseController
            exit();
        }

        // Load view untuk menampilkan formulir pendaftaran
        $this->view('register'); // Menggunakan view dari BaseController
    }

    /**
     * Memproses data POST dari formulir pendaftaran.
     * Mendaftarkan pengguna baru ke database.
     */
    public function store() {
        // Cek apakah request datang dari metode POST
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            // Ambil data dari input form
            $fullname = $_POST['fullname'] ?? '';
            $jenis_kelamin = $_POST['jenis_kelamin'] ?? '';
            $email = $_POST['email'] ?? '';
            $username = $_POST['username'] ?? '';
            $password = $_POST['password'] ?? '';
            $password_confirm = $_POST['password_confirm'] ?? '';
            $no_hp = $_POST['no_hp'] ?? null;
            $foto = null; // Penanganan upload foto profil bisa ditambahkan nanti

            // Validasi input dasar
            if (empty($fullname) || empty($jenis_kelamin) || empty($email) || empty($username) || empty($password) || empty($password_confirm)) {
                $this->setErrorMessage("Semua kolom wajib diisi.");
                $this->redirect('register_create');
                exit();
            }

            if ($password !== $password_confirm) {
                $this->setErrorMessage("Konfirmasi password tidak cocok.");
                $this->redirect('register_create');
                exit();
            }

            // Validasi format email sederhana
            if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
                $this->setErrorMessage("Format email tidak valid.");
                $this->redirect('register_create');
                exit();
            }

            // PASTIKAN BARIS INI (BARIS 64) SUDAH BENAR:
            $userModel = new Users($this->conn); // Meneruskan koneksi ke model

            // Coba tambahkan pengguna ke database
            $result = $userModel->addUser($fullname, $jenis_kelamin, $email, $username, $password, $no_hp, 'user', $foto);

            if ($result) {
                $this->setSuccessMessage("Pendaftaran berhasil! Silakan login.");
                $this->redirect('login'); // Arahkan ke halaman login
                exit();
            } else {
                $this->setErrorMessage("Gagal mendaftar. Username atau Email mungkin sudah terdaftar.");
                $this->redirect('register_create'); // Kembali ke form pendaftaran
                exit();
            }
        } else {
            // Jika bukan POST request, arahkan kembali ke halaman pendaftaran
            $this->redirect('register_create');
            exit();
        }
    }
}
