<?php
// controllers/LoginController.php

// Memastikan model Users di-include agar bisa digunakan untuk verifikasi login
require_once dirname(__DIR__) . '/models/Users.php';
// Pastikan BaseController di-include
require_once dirname(__DIR__) . '/controllers/BaseController.php';

// Pastikan kelas ini mewarisi dari BaseController
class LoginController extends BaseController {

    /**
     * Konstruktor untuk LoginController.
     * Menerima objek koneksi MySQLi dan meneruskannya ke BaseController.
     * @param mysqli $conn Objek koneksi database MySQLi.
     */
    public function __construct(mysqli $conn) {
        // Panggil konstruktor parent (BaseController) untuk menginisialisasi $this->conn
        parent::__construct($conn);
    }

    /**
     * Menampilkan formulir login pengguna.
     * Jika pengguna sudah login, akan diarahkan ke halaman utama.
     */
    public function index() {
        // Cek apakah user sudah login, jika ya, arahkan ke home
        if (isset($_SESSION['user_id'])) {
            $this->redirect('home'); // Menggunakan redirect dari BaseController
            exit();
        }

        // Load view untuk menampilkan formulir login
        $this->view('login'); // Menggunakan view dari BaseController
    }

    /**
     * Memproses data POST dari formulir login.
     * Melakukan autentikasi pengguna.
     */
    public function authenticate() {
        // Cek apakah request datang dari metode POST
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            // Ambil data dari input form
            $username = $_POST['username'] ?? '';
            $password = $_POST['password'] ?? '';

            // Validasi input dasar
            if (empty($username) || empty($password)) {
                $this->setErrorMessage("Username dan Password harus diisi."); // Menggunakan setErrorMessage
                $this->redirect('login');
                exit();
            }

            // BARIS 45: Pastikan koneksi diteruskan ke model Users
            $userModel = new Users($this->conn); // KONEKSI DITERUSKAN DI SINI!
            $user = $userModel->getUserByUsername($username);

            // Verifikasi pengguna
            if ($user && password_verify($password, $user['password'])) {
                // Login berhasil
                $_SESSION['user_id'] = $user['id'];
                $_SESSION['username'] = $user['username'];
                $_SESSION['user_role'] = $user['role'];
                $_SESSION['fullname'] = $user['fullname']; // Pastikan ini juga disimpan
                $_SESSION['foto'] = $user['foto'];       // Pastikan ini juga disimpan

                $this->setSuccessMessage("Login berhasil! Selamat datang, " . htmlspecialchars($user['fullname']) . ".");
                $this->redirect('home'); // Redirect ke halaman utama
                exit();
            } else {
                // Login gagal
                $this->setErrorMessage("Username atau password salah.");
                $this->redirect('login');
                exit();
            }
        } else {
            // Jika bukan POST request, arahkan kembali ke halaman login
            $this->redirect('login');
            exit();
        }
    }

    /**
     * Menangani proses logout pengguna.
     */
    public function logout() {
        // Hancurkan semua sesi
        session_unset();
        session_destroy();
        $this->setSuccessMessage("Anda telah berhasil logout.");
        $this->redirect('home'); // Arahkan ke halaman login setelah logout
        exit();
    }
}
