<?php
// controllers/BaseController.php

abstract class BaseController {
    protected $conn;
    protected $data = [];

    public function __construct(mysqli $conn) {
        $this->conn = $conn;
    }

    protected function view($view_path, $data = []) {
        extract($data);
        include dirname(__DIR__) . '/views/header.php';
        include dirname(__DIR__) . '/views/navigation.php';
        $full_view_path = dirname(__DIR__) . '/views/' . $view_path . '.php';
        if (file_exists($full_view_path)) {
            include $full_view_path;
        } else {
            echo "Error: View file not found: " . htmlspecialchars($view_path) . ".php";
        }
        include dirname(__DIR__) . '/views/footer.php';
    }

    /**
     * Metode untuk melakukan redirect HTTP ke URL berbasis index.php?hal=.
     *
     * @param string $hal_param Nama parameter 'hal' (misal: 'login', 'film_detail').
     * @param array $params_array Array asosiatif parameter tambahan (misal: ['id' => 1]).
     */
    protected function redirect($hal_param, $params_array = []) {
        $url = 'index.php?hal=' . urlencode($hal_param);
        foreach ($params_array as $key => $value) {
            $url .= '&' . urlencode($key) . '=' . urlencode($value);
        }
        header('Location: ' . $url);
        exit();
    }

    protected function setSuccessMessage($message) {
        $_SESSION['success_message'] = $message;
    }

    protected function setErrorMessage($message) {
        $_SESSION['error_message'] = $message;
    }

    protected function setInfoMessage($message) {
        $_SESSION['info_message'] = $message;
    }

    protected function requireAuth() {
        if (!isset($_SESSION['user_id'])) {
            $this->setErrorMessage("Anda harus login untuk mengakses halaman ini.");
            $this->redirect('login'); 
            exit(); // Pastikan ada exit setelah redirect
        }
    }

    /**
     * Memeriksa apakah pengguna yang sedang login memiliki peran 'admin'.
     * Ini adalah method yang hilang dan perlu ditambahkan.
     * @return bool True jika pengguna adalah admin, false jika tidak.
     */
    protected function isAdmin() {
        // Asumsi peran pengguna disimpan di $_SESSION['user_role']
        return isset($_SESSION['user_role']) && $_SESSION['user_role'] === 'admin';
    }

    protected function requireAdmin() {
        $this->requireAuth(); // Pastikan user sudah login dulu
        // Memanggil isAdmin() yang baru kita definisikan
        if (!$this->isAdmin()) { 
            $this->setErrorMessage("Anda tidak memiliki akses sebagai admin.");
            $this->redirect('home'); 
            exit(); // Pastikan ada exit setelah redirect
        }
    }
}